/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EComboBox;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EPasswordField;
import org.phosphoresce.commons.eswing.ETextField;
import org.phosphoresce.commons.eswing.extend.EFieldSet;
import org.phosphoresce.dbbrowser.DatabaseBrowserProperties;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.exception.BrowserPropertiesException;
import org.phosphoresce.dbbrowser.gui.common.DialogHeaderPanel;
import org.phosphoresce.dbbrowser.gui.common.window.MessageDialog;

public class ConnectionConfigureFrame
extends EDialog {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private DatabaseBrowserSession browserSession = null;
    private ConnectionConfigureFrame instance = null;
    private EPanel contentsPanel = null;
    private DialogHeaderPanel dialogHeaderPanel = null;
    private EFieldSet jdbcFieldSet = null;
    private ELabel jdbcDefinitionListLabel = null;
    private EComboBox jdbcDefinitionList = null;
    private ELabel jdbcDefinitionNameLabel = null;
    private ETextField jdbcDefinitionNameField = null;
    private ELabel jdbcDriverClassLabel = null;
    private ETextField jdbcDriverClassField = null;
    private ELabel jdbcUrlLabel = null;
    private ETextField jdbcUrlField = null;
    private ELabel jdbcUserLabel = null;
    private ETextField jdbcUserField = null;
    private ELabel jdbcPasswordLabel = null;
    private EPasswordField jdbcPasswordField = null;
    private EPanel buttonPanel = null;
    private ELabel buttonPanelSpacer = null;
    private EButton cancelButton = null;
    private EButton clearButton = null;
    private EButton connectButton = null;
    private EButton saveButton = null;

    public ConnectionConfigureFrame(Frame frame, DatabaseBrowserSession browserSession) throws BrowserPropertiesException {
        super(frame, true);
        this.browserSession = browserSession;
        this.instance = this;
        this.initialize();
        this.storeConfig(DatabaseBrowserProperties.instance().getRecentJdbcConfig());
        this.storeConfigList();
    }

    private void storeConfigList() {
        try {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement("< Recent Connection >");
            Iterator iterator = DatabaseBrowserProperties.instance().getJdbcConfigNameList().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                model.addElement(name);
            }
            this.getJdbcDefinitionList().setModel(model);
        }
        catch (Throwable throwable) {
            MessageDialog.showError((Dialog)((Object)this.instance), "failed to load connection definitions.", throwable);
        }
    }

    private void storeConfig(DatabaseConfig config) {
        if (config != null) {
            this.getJdbcDriverClassField().setText(config.getJdbcDriver());
            this.getJdbcUrlField().setText(config.getJdbcUrl());
            this.getJdbcUserField().setText(config.getJdbcUser());
            this.getJdbcPasswordField().setText(config.getJdbcPassword());
        } else {
            this.getJdbcDriverClassField().setText("");
            this.getJdbcUrlField().setText("");
            this.getJdbcUserField().setText("");
            this.getJdbcPasswordField().setText("");
        }
    }

    private DatabaseConfig makeConfig() {
        DatabaseConfig config = new DatabaseConfig();
        config.setJdbcDriver(this.getJdbcDriverClassField().getText());
        config.setJdbcUrl(this.getJdbcUrlField().getText());
        config.setJdbcUser(this.getJdbcUserField().getText());
        config.setJdbcPassword(new String(this.getJdbcPasswordField().getPassword()));
        return config;
    }

    private ConnectionConfigureFrame() throws BrowserPropertiesException {
        this(null, null);
    }

    private void initialize() {
        this.setSize(new Dimension(465, 319));
        this.setContentPane((Container)this.getContentsPanel());
        this.setTitle("Database Browser");
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton((JButton)this.getConnectButton());
    }

    private EPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints17.fill = 1;
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.gridy = 2;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.weighty = 1.0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(4, 10, 4, 10);
            gridBagConstraints16.fill = 1;
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.gridy = 1;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.weighty = 0.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 0.0;
            this.contentsPanel = new EPanel();
            this.contentsPanel.setLayout((LayoutManager)new GridBagLayout());
            this.contentsPanel.add((Component)((Object)this.getDialogHeaderPanel()), (Object)gridBagConstraints1);
            this.contentsPanel.add((Component)this.getJdbcFieldSet(), (Object)gridBagConstraints16);
            this.contentsPanel.add((Component)this.getButtonPanel(), (Object)gridBagConstraints17);
        }
        return this.contentsPanel;
    }

    private DialogHeaderPanel getDialogHeaderPanel() {
        if (this.dialogHeaderPanel == null) {
            this.dialogHeaderPanel = new DialogHeaderPanel();
            this.dialogHeaderPanel.setText("Configure JDBC Connection");
        }
        return this.dialogHeaderPanel;
    }

    private EFieldSet getJdbcFieldSet() {
        if (this.jdbcFieldSet == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.gridy = 5;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 0.0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 5;
            gridBagConstraints14.weightx = 0.0;
            gridBagConstraints14.weighty = 0.0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.gridy = 4;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 0.0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 4;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.weighty = 0.0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 0.0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 3;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.weighty = 0.0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 0.0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.weighty = 0.0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 0.0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.weighty = 0.0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 0.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.jdbcFieldSet = new EFieldSet();
            this.jdbcFieldSet.setLayout((LayoutManager)new GridBagLayout());
            this.jdbcFieldSet.setText("JDBC Connection Config");
            this.jdbcFieldSet.setPreferredSize(new Dimension(436, 185));
            this.jdbcFieldSet.setMaximumSize(new Dimension(436, 185));
            this.jdbcFieldSet.setMinimumSize(new Dimension(436, 185));
            this.jdbcFieldSet.add((Component)this.getJdbcDefinitionListLabel(), (Object)gridBagConstraints);
            this.jdbcFieldSet.add((Component)this.getJdbcDefinitionList(), (Object)gridBagConstraints5);
            this.jdbcFieldSet.add((Component)this.getJdbcDefinitionNameLabel(), (Object)gridBagConstraints6);
            this.jdbcFieldSet.add((Component)this.getJdbcDefinitionNameField(), (Object)gridBagConstraints7);
            this.jdbcFieldSet.add((Component)this.getJdbcDriverClassLabel(), (Object)gridBagConstraints8);
            this.jdbcFieldSet.add((Component)this.getJdbcDriverClassField(), (Object)gridBagConstraints9);
            this.jdbcFieldSet.add((Component)this.getJdbcUrlLabel(), (Object)gridBagConstraints10);
            this.jdbcFieldSet.add((Component)this.getJdbcUrlField(), (Object)gridBagConstraints11);
            this.jdbcFieldSet.add((Component)this.getJdbcUserLabel(), (Object)gridBagConstraints12);
            this.jdbcFieldSet.add((Component)this.getJdbcUserField(), (Object)gridBagConstraints13);
            this.jdbcFieldSet.add((Component)this.getJdbcPasswordLabel(), (Object)gridBagConstraints14);
            this.jdbcFieldSet.add((Component)this.getJdbcPasswordField(), (Object)gridBagConstraints15);
        }
        return this.jdbcFieldSet;
    }

    private ELabel getJdbcDefinitionListLabel() {
        if (this.jdbcDefinitionListLabel == null) {
            this.jdbcDefinitionListLabel = new ELabel();
            this.jdbcDefinitionListLabel.setText("Definiction List :");
            this.jdbcDefinitionListLabel.setPreferredSize(new Dimension(120, 22));
            this.jdbcDefinitionListLabel.setMaximumSize(new Dimension(120, 22));
            this.jdbcDefinitionListLabel.setMinimumSize(new Dimension(120, 22));
        }
        return this.jdbcDefinitionListLabel;
    }

    private EComboBox getJdbcDefinitionList() {
        if (this.jdbcDefinitionList == null) {
            this.jdbcDefinitionList = new EComboBox();
            this.jdbcDefinitionList.setPreferredSize(new Dimension(280, 22));
            this.jdbcDefinitionList.setMaximumSize(new Dimension(280, 22));
            this.jdbcDefinitionList.setMinimumSize(new Dimension(280, 22));
            this.jdbcDefinitionList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        int index = ConnectionConfigureFrame.this.getJdbcDefinitionList().getSelectedIndex();
                        if (index == 0) {
                            ConnectionConfigureFrame.this.storeConfig(DatabaseBrowserProperties.instance().getRecentJdbcConfig());
                            ConnectionConfigureFrame.this.getJdbcDefinitionNameField().setText("");
                        } else {
                            ConnectionConfigureFrame.this.storeConfig(DatabaseBrowserProperties.instance().getJdbcConfig(index));
                            ConnectionConfigureFrame.this.getJdbcDefinitionNameField().setText(DatabaseBrowserProperties.instance().getJdbcConfigName(index));
                        }
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to load connection definition.";
                        ConnectionConfigureFrame.this.log.error((Object)errorMessage, throwable);
                        MessageDialog.showError((Dialog)((Object)ConnectionConfigureFrame.this.instance), errorMessage, throwable);
                    }
                }
            });
        }
        return this.jdbcDefinitionList;
    }

    private ELabel getJdbcDefinitionNameLabel() {
        if (this.jdbcDefinitionNameLabel == null) {
            this.jdbcDefinitionNameLabel = new ELabel();
            this.jdbcDefinitionNameLabel.setText("Definition Name :");
            this.jdbcDefinitionNameLabel.setPreferredSize(new Dimension(120, 22));
            this.jdbcDefinitionNameLabel.setMaximumSize(new Dimension(120, 22));
            this.jdbcDefinitionNameLabel.setMinimumSize(new Dimension(120, 22));
        }
        return this.jdbcDefinitionNameLabel;
    }

    private ETextField getJdbcDefinitionNameField() {
        if (this.jdbcDefinitionNameField == null) {
            this.jdbcDefinitionNameField = new ETextField();
            this.jdbcDefinitionNameField.setPreferredSize(new Dimension(280, 22));
            this.jdbcDefinitionNameField.setMaximumSize(new Dimension(280, 22));
            this.jdbcDefinitionNameField.setMinimumSize(new Dimension(280, 22));
        }
        return this.jdbcDefinitionNameField;
    }

    private ELabel getJdbcDriverClassLabel() {
        if (this.jdbcDriverClassLabel == null) {
            this.jdbcDriverClassLabel = new ELabel();
            this.jdbcDriverClassLabel.setText("JDBC Driver Class :");
            this.jdbcDriverClassLabel.setPreferredSize(new Dimension(120, 22));
            this.jdbcDriverClassLabel.setMaximumSize(new Dimension(120, 22));
            this.jdbcDriverClassLabel.setMinimumSize(new Dimension(120, 22));
        }
        return this.jdbcDriverClassLabel;
    }

    private ETextField getJdbcDriverClassField() {
        if (this.jdbcDriverClassField == null) {
            this.jdbcDriverClassField = new ETextField();
            this.jdbcDriverClassField.setPreferredSize(new Dimension(280, 22));
            this.jdbcDriverClassField.setMaximumSize(new Dimension(280, 22));
            this.jdbcDriverClassField.setMinimumSize(new Dimension(280, 22));
        }
        return this.jdbcDriverClassField;
    }

    private ELabel getJdbcUrlLabel() {
        if (this.jdbcUrlLabel == null) {
            this.jdbcUrlLabel = new ELabel();
            this.jdbcUrlLabel.setText("JDBC URL :");
            this.jdbcUrlLabel.setPreferredSize(new Dimension(120, 22));
            this.jdbcUrlLabel.setMaximumSize(new Dimension(120, 22));
            this.jdbcUrlLabel.setMinimumSize(new Dimension(120, 22));
        }
        return this.jdbcUrlLabel;
    }

    private ETextField getJdbcUrlField() {
        if (this.jdbcUrlField == null) {
            this.jdbcUrlField = new ETextField();
            this.jdbcUrlField.setPreferredSize(new Dimension(280, 22));
            this.jdbcUrlField.setMaximumSize(new Dimension(280, 22));
            this.jdbcUrlField.setMinimumSize(new Dimension(280, 22));
        }
        return this.jdbcUrlField;
    }

    private ELabel getJdbcUserLabel() {
        if (this.jdbcUserLabel == null) {
            this.jdbcUserLabel = new ELabel();
            this.jdbcUserLabel.setText("JDBC User :");
            this.jdbcUserLabel.setPreferredSize(new Dimension(120, 22));
            this.jdbcUserLabel.setMaximumSize(new Dimension(120, 22));
            this.jdbcUserLabel.setMinimumSize(new Dimension(120, 22));
        }
        return this.jdbcUserLabel;
    }

    private ETextField getJdbcUserField() {
        if (this.jdbcUserField == null) {
            this.jdbcUserField = new ETextField();
            this.jdbcUserField.setPreferredSize(new Dimension(280, 22));
            this.jdbcUserField.setMaximumSize(new Dimension(280, 22));
            this.jdbcUserField.setMinimumSize(new Dimension(280, 22));
        }
        return this.jdbcUserField;
    }

    private ELabel getJdbcPasswordLabel() {
        if (this.jdbcPasswordLabel == null) {
            this.jdbcPasswordLabel = new ELabel();
            this.jdbcPasswordLabel.setText("JDBC Password :");
            this.jdbcPasswordLabel.setPreferredSize(new Dimension(120, 22));
            this.jdbcPasswordLabel.setMaximumSize(new Dimension(120, 22));
            this.jdbcPasswordLabel.setMinimumSize(new Dimension(120, 22));
        }
        return this.jdbcPasswordLabel;
    }

    private EPasswordField getJdbcPasswordField() {
        if (this.jdbcPasswordField == null) {
            this.jdbcPasswordField = new EPasswordField();
            this.jdbcPasswordField.setPreferredSize(new Dimension(280, 22));
            this.jdbcPasswordField.setMaximumSize(new Dimension(280, 22));
            this.jdbcPasswordField.setMinimumSize(new Dimension(280, 22));
        }
        return this.jdbcPasswordField;
    }

    private EPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 0.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints4.gridx = 4;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.weighty = 0.0;
            this.buttonPanel = new EPanel();
            this.buttonPanel.setLayout((LayoutManager)new GridBagLayout());
            this.buttonPanel.setPreferredSize(new Dimension(400, 36));
            this.buttonPanel.setMaximumSize(new Dimension(400, 36));
            this.buttonPanel.setMinimumSize(new Dimension(400, 36));
            this.buttonPanel.add((Component)this.getSaveButton(), (Object)gridBagConstraints);
            this.buttonPanel.add((Component)this.getButtonPanelSpacer(), (Object)gridBagConstraints1);
            this.buttonPanel.add((Component)this.getConnectButton(), (Object)gridBagConstraints2);
            this.buttonPanel.add((Component)this.getClearButton(), (Object)gridBagConstraints3);
            this.buttonPanel.add((Component)this.getCancelButton(), (Object)gridBagConstraints4);
        }
        return this.buttonPanel;
    }

    private ELabel getButtonPanelSpacer() {
        if (this.buttonPanelSpacer == null) {
            this.buttonPanelSpacer = new ELabel();
        }
        return this.buttonPanelSpacer;
    }

    private EButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new EButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setPreferredSize(new Dimension(86, 24));
            this.cancelButton.setMaximumSize(new Dimension(86, 24));
            this.cancelButton.setMinimumSize(new Dimension(86, 24));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionConfigureFrame.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private EButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new EButton();
            this.clearButton.setText("Clear");
            this.clearButton.setPreferredSize(new Dimension(86, 24));
            this.clearButton.setMaximumSize(new Dimension(86, 24));
            this.clearButton.setMinimumSize(new Dimension(86, 24));
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionConfigureFrame.this.getJdbcDefinitionNameField().setText("");
                    ConnectionConfigureFrame.this.getJdbcDriverClassField().setText("");
                    ConnectionConfigureFrame.this.getJdbcUrlField().setText("");
                    ConnectionConfigureFrame.this.getJdbcUserField().setText("");
                    ConnectionConfigureFrame.this.getJdbcPasswordField().setText("");
                }
            });
        }
        return this.clearButton;
    }

    private EButton getConnectButton() {
        if (this.connectButton == null) {
            this.connectButton = new EButton();
            this.connectButton.setText("Connect");
            this.connectButton.setPreferredSize(new Dimension(86, 24));
            this.connectButton.setMaximumSize(new Dimension(86, 24));
            this.connectButton.setMinimumSize(new Dimension(86, 24));
            this.connectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        DatabaseConfig config = ConnectionConfigureFrame.this.makeConfig();
                        new DatabaseSession(config).close();
                        ConnectionConfigureFrame.this.browserSession.setConfig(config);
                        DatabaseBrowserProperties.instance().setRecentJdbcConfig(config);
                        DatabaseBrowserProperties.instance().save();
                        ConnectionConfigureFrame.this.dispose();
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to connect database.";
                        ConnectionConfigureFrame.this.log.error((Object)errorMessage, throwable);
                        MessageDialog.showError((Dialog)((Object)ConnectionConfigureFrame.this.instance), errorMessage, throwable);
                    }
                }
            });
        }
        return this.connectButton;
    }

    private EButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new EButton();
            this.saveButton.setText("Save");
            this.saveButton.setPreferredSize(new Dimension(86, 24));
            this.saveButton.setMaximumSize(new Dimension(86, 24));
            this.saveButton.setMinimumSize(new Dimension(86, 24));
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String name = ConnectionConfigureFrame.this.getJdbcDefinitionNameField().getText();
                        if ("".equals(name.trim())) {
                            MessageDialog.showError((Dialog)((Object)ConnectionConfigureFrame.this.instance), "definition name is empty.");
                        } else {
                            int result;
                            if (DatabaseBrowserProperties.instance().containJdbcConfigName(name) && (result = MessageDialog.showQuestion((Dialog)((Object)ConnectionConfigureFrame.this.instance), "'" + name + "' is already exist.<br>over write this definition ?")) != 2) {
                                return;
                            }
                            DatabaseConfig config = ConnectionConfigureFrame.this.makeConfig();
                            DatabaseBrowserProperties.instance().setJdbcConfig(name, config);
                            DatabaseBrowserProperties.instance().save();
                            ConnectionConfigureFrame.this.storeConfigList();
                        }
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to save connection definition.";
                        ConnectionConfigureFrame.this.log.error((Object)errorMessage, throwable);
                        MessageDialog.showError((Dialog)((Object)ConnectionConfigureFrame.this.instance), errorMessage, throwable);
                    }
                }
            });
        }
        return this.saveButton;
    }
}

