/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;

public class DialogHeaderPanel
extends EPanel {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ELabel applicationLogoImage = null;
    private ELabel headerMessage = null;

    public DialogHeaderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.black));
        this.setSize(new Dimension(400, 62));
        this.setPreferredSize(new Dimension(400, 62));
        this.setMinimumSize(new Dimension(1, 62));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 62));
        this.add((Component)this.getApplicationLogoImage(), null);
        this.add((Component)this.getHeaderMessage(), null);
    }

    private ELabel getApplicationLogoImage() {
        if (this.applicationLogoImage == null) {
            this.applicationLogoImage = new ELabel();
            this.applicationLogoImage.setBounds(new Rectangle(10, 10, 161, 24));
            this.applicationLogoImage.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_APP_LOGO_24));
        }
        return this.applicationLogoImage;
    }

    private ELabel getHeaderMessage() {
        if (this.headerMessage == null) {
            this.headerMessage = new ELabel();
            this.headerMessage.setText("");
            this.headerMessage.setBounds(new Rectangle(15, 35, 51, 22));
        }
        return this.headerMessage;
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        Rectangle rectangle = this.getHeaderMessage().getBounds();
        rectangle.width = this.getPreferredSize().width - 30;
        this.getHeaderMessage().setBounds(rectangle);
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        Rectangle rectangle = this.getHeaderMessage().getBounds();
        rectangle.width = this.getSize().width - 30;
        this.getHeaderMessage().setBounds(rectangle);
    }

    public void setText(String message) {
        if (message == null) {
            this.getHeaderMessage().setText("");
        } else {
            this.getHeaderMessage().setText(message);
        }
    }

    public String getText() {
        return this.getHeaderMessage().getText();
    }
}

