/*
 * Decompiled with CFR 0.152.
 */
package primitive;

import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import primitive.HaplotypeFrequency;
import primitive.SnpData;
import primitive.Snp_DataReader;
import primitive.pearson;

public class typeI {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        double gen = 10000.0;
        String[] data1 = fileload.loadLine0(args[0]);
        SnpData[] snpData1 = new SnpData[data1.length];
        int j = 0;
        while (j < data1.length) {
            snpData1[j] = Snp_DataReader.DataReaderSetData(data1[j], 2);
            ++j;
        }
        String[] data2 = fileload.loadLine0(args[1]);
        SnpData[] snpData2 = new SnpData[data2.length];
        int j2 = 0;
        while (j2 < data2.length) {
            snpData2[j2] = Snp_DataReader.DataReaderSetData(data2[j2], 2);
            ++j2;
        }
        SnpData[][] data = Snp_DataReader.DataReaderMakeParallelData(snpData1, snpData2);
        int a = data[0][0].SNPdata.length;
        int b = data[1][0].SNPdata.length;
        double Sobs = 0.0;
        int top = 0;
        int j3 = 0;
        while (j3 < data[0].length) {
            int[] populationType = Snp_DataReader.populationType(data[0][j3], data[1][j3]);
            int[][] Tobs = Snp_DataReader.DataReaderMakeTable(data[0][j3], data[1][j3], populationType);
            double S = pearson.S(Tobs);
            if (S != Double.NaN && S > Sobs) {
                Sobs = S;
                top = j3;
            }
            ++j3;
        }
        System.out.print("Observed:");
        System.out.print(data[0][top].rsNumber);
        System.out.print("\t");
        System.out.print(Sobs);
        System.out.println();
        HaplotypeFrequency[] HaplotypeFrequency2 = Snp_DataReader.haplotypeFrequency(data);
        int haplotypeNumber = HaplotypeFrequency2.length;
        String[] haplotype = new String[haplotypeNumber];
        double[] freq = new double[haplotypeNumber];
        double sum = 0.0;
        int h = 0;
        while (h < haplotypeNumber) {
            sum += (double)HaplotypeFrequency2[h].count;
            ++h;
        }
        h = 0;
        while (h < haplotypeNumber) {
            freq[h] = (double)HaplotypeFrequency2[h].count / sum;
            haplotype[h] = HaplotypeFrequency2[h].haplotype;
            ++h;
        }
        System.out.println("start sampling");
        int burnin = 0;
        while ((double)burnin < 1.0 + gen * 0.0) {
            int copyNumber = (int)sum;
            long time = System.currentTimeMillis();
            int L = freq.length;
            int[][] X = new int[2][L];
            X[0] = typeI.startSet(a, freq);
            X[1] = typeI.startSet(b, freq);
            int m = 0;
            while (m < burnin) {
                typeI.markov(X, freq);
                ++m;
            }
            double total = 0.0;
            double diff = 0.0;
            SnpData[][] resampledData = new SnpData[2][];
            int n = 0;
            while (n < 200) {
                diff = 0.0;
                int m2 = 0;
                while ((double)m2 < gen) {
                    total += 1.0;
                    typeI.markov(X, freq);
                    int pop = 0;
                    while (pop < resampledData.length) {
                        resampledData[pop] = Snp_DataReader.sequenceToSnpData(typeI.sampling(X[pop], haplotype));
                        ++pop;
                    }
                    int j4 = 0;
                    while (j4 < resampledData[0].length) {
                        int[] populationType = Snp_DataReader.populationType(resampledData[0][j4], resampledData[1][j4]);
                        int[][] Tresample = Snp_DataReader.DataReaderMakeTable(resampledData[0][j4], resampledData[1][j4], populationType);
                        double S = pearson.S(Tresample);
                        if (S >= Sobs) {
                            diff += 1.0;
                        }
                        ++j4;
                    }
                    ++m2;
                }
                System.out.print(a);
                System.out.print("\t");
                System.out.print(b);
                System.out.print("\t");
                System.out.print(copyNumber);
                System.out.print("\t");
                System.out.print(burnin);
                System.out.print("\t");
                System.out.print(diff / gen);
                System.out.print("\t");
                System.out.println((System.currentTimeMillis() - time) / 1000L);
                ++n;
            }
            burnin += 100000;
        }
    }

    public static String[] sampling(int[] X, String[] haplotype) {
        int numberOfSequences = 0;
        int haplotypeNumber = X.length;
        int h = 0;
        while (h < haplotypeNumber) {
            numberOfSequences += X[h];
            ++h;
        }
        String[] sequences = new String[numberOfSequences];
        int tmp = 0;
        int h2 = 0;
        while (h2 < haplotypeNumber) {
            int h22 = 0;
            while (h22 < X[h2]) {
                sequences[tmp] = haplotype[h2];
                ++tmp;
                ++h22;
            }
            ++h2;
        }
        return sequences;
    }

    public static void markov(int[][] X, double[] h) {
        int u;
        int L = X[0].length;
        int j = typeI.zeroOne();
        if (X[j][u = typeI.random(L)] != 0) {
            int v = 0;
            while (u == (v = typeI.random(L))) {
            }
            int XjuStar = X[j][u] - 1;
            int XjvStar = X[j][v] + 1;
            double c = h[v] * (double)X[j][u] / (h[u] * (double)(X[j][v] + 1));
            if (c >= 1.0) {
                X[j][u] = XjuStar;
                X[j][v] = XjvStar;
            } else {
                double tmp = Math.random();
                if (tmp < c) {
                    X[j][u] = XjuStar;
                    X[j][v] = XjvStar;
                }
            }
        }
    }

    static int[] startSet2(int samplesize, int L) {
        int[] result = new int[L];
        result[0] = samplesize;
        return result;
    }

    static int[] startSet(int samplesize, double[] frequency) {
        int L = frequency.length;
        int[] result = new int[L];
        int j = 0;
        while (j < samplesize) {
            int n = typeI.discreteRandomValue(frequency);
            result[n] = result[n] + 1;
            ++j;
        }
        return result;
    }

    static int zeroOne() {
        int result = (int)(Math.random() * 2.0);
        return result;
    }

    static int random(int L) {
        int result = (int)(Math.random() * (double)L);
        return result;
    }

    static int discreteRandomValue(double[] xlist) {
        int len = xlist.length;
        double all = 0.0;
        int i = 0;
        while (i < len) {
            all += xlist[i];
            ++i;
        }
        double x = Math.random() * all;
        int num = 0;
        double tmp = 0.0;
        i = 0;
        while (i < len) {
            if (x > (tmp += xlist[i])) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public static double typeIMain(SnpData[][] data, double Sobs, int generation, int burnin) {
        if (Sobs < 3.84) {
            return Double.NaN;
        }
        double gen = generation;
        HaplotypeFrequency[] HaplotypeFrequency2 = Snp_DataReader.haplotypeFrequency(data);
        int haplotypeNumber = HaplotypeFrequency2.length;
        String[] haplotype = new String[haplotypeNumber];
        double[] freq = new double[haplotypeNumber];
        double sum = 0.0;
        int h = 0;
        while (h < haplotypeNumber) {
            sum += (double)HaplotypeFrequency2[h].count;
            ++h;
        }
        h = 0;
        while (h < haplotypeNumber) {
            freq[h] = (double)HaplotypeFrequency2[h].count / sum;
            haplotype[h] = HaplotypeFrequency2[h].haplotype;
            ++h;
        }
        int L = freq.length;
        int[][] X = new int[2][L];
        int a = data[0][0].SNPdata.length;
        int b = data[1][0].SNPdata.length;
        X[0] = typeI.startSet(a, freq);
        X[1] = typeI.startSet(b, freq);
        int m = 0;
        while (m < burnin) {
            typeI.markov(X, freq);
            ++m;
        }
        double total = 0.0;
        double diff = 0.0;
        SnpData[][] resampledData = new SnpData[2][];
        int n = 0;
        while (n < 200) {
            diff = 0.0;
            int m2 = 0;
            while ((double)m2 < gen) {
                total += 1.0;
                typeI.markov(X, freq);
                int pop = 0;
                while (pop < resampledData.length) {
                    resampledData[pop] = Snp_DataReader.sequenceToSnpData(typeI.sampling(X[pop], haplotype));
                    ++pop;
                }
                int j = 0;
                while (j < resampledData[0].length) {
                    int[] populationType = Snp_DataReader.populationType(resampledData[0][j], resampledData[1][j]);
                    int[][] Tresample = Snp_DataReader.DataReaderMakeTable(resampledData[0][j], resampledData[1][j], populationType);
                    double S = pearson.S(Tresample);
                    if (S >= Sobs) {
                        diff += 1.0;
                    }
                    ++j;
                }
                ++m2;
            }
            ++n;
        }
        return diff / gen;
    }
}

