/*!
    \file   string.cpp
    \brief  standard library

    standard library

    Copyright (c) 2002,2003 Higepon and the individuals listed on the ChangeLog entries.
    All rights reserved.
    License=MIT/X Licnese

    \author  HigePon
    \version $Revision: 1.15 $
    \date   create:2002/12/15 update:$Date: 2004/03/18 13:42:26 $
*/
#include <string.h>

/*!
    \brief memmove
*/
void *memmove(void* s1, const void* s2, size_t size)
{
    void *p = s1;
    char *c1 = (char*)s1;
    char *c2 = (char*)s2;

    if (c1 > c2) {
        c1 += size;
        c2 += size;
        while (0 < size--)
            *c1-- = *c2--;
    } else {
        while (0 < size--)
            *c1++ = *c2++;
    }

    return p;
}
