
#include <pekoe.h>
#include <stdio.h>
#include <sys/rpcss.h>
#include <sys/gbc.h>
#include <sys/IPointerDevice.h>


extern	"C"{
int	CreateThread(int stacksize,void (*startthread)(void*),void* param);
}


byte my_cursor [16][16] = {
	{0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x10,0x0F,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x0F,0x10,0x00,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x0F,0x10,0x10,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x10,0x07,0x0f,0x10,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x10,0x00},
	{0x00,0x00,0x00,0x10,0x07,0x07,0x07,0x07,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00},
	{0x00,0x00,0x00,0x00,0x10,0x10,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
};

class MouseDevice: public IPointerDevice {
	KMODE_SPINLOCK mouse_thread_alive;
	volatile int contflag;
	void ThreadProc();
public:
	MouseDevice();
	virtual ~MouseDevice();
	friend	void mouse_thread_stub(void* dev);
};


void mouse_thread_stub(void* dev){
	MouseDevice* p=(MouseDevice*)dev;
	p->ThreadProc();
}

void MouseDevice::ThreadProc(){
	int count;
	MOUSE_PACKET packet;

	sys_acquire_spinlock(&mouse_thread_alive);
	for(;contflag;sys_wait()){
		count=sys_fs_read(devid_rpcss,port_mouse,0,&packet,1);
		if(count>0){
			x+=packet.x;if(x<0) x=0;if(x>w) x=w;
			y+=packet.y;if(y<0) y=0;if(y>h) y=h;
			button=packet.button;
			if(packet.x||packet.y){
				if(dispflag){
					gbc_restore_cursor_block();
					gbc_save_cursor_block(x,y);
					gbc_blt_trans(8,x,y,16,16,cursor);
				}
				if(delegate) delegate->OnMove(x,y);
			}
			if(packet.button_change&packet.button_press)
				if(delegate) delegate->OnButtonDown(button,packet.button_change&packet.button_press);
			if(packet.button_change&~packet.button_press)
				if(delegate) delegate->OnButtonUp(button,packet.button_change&~packet.button_press);
		}
	}
	sys_release_spinlock(&mouse_thread_alive);
}

MouseDevice::MouseDevice(){
	puts("mouse ctor");
	GSSTATUS	gs;
	sys_gs_get_status(&gs);
	w=gs.width,h=gs.height,x=w/2,y=h/2;

	cursor=&my_cursor[0][0];

	contflag=1;
	sys_release_spinlock(&mouse_thread_alive);
	CreateThread(4080,mouse_thread_stub,this);
}

MouseDevice::~MouseDevice(){
	gbc_restore_cursor_block();
	contflag=0;
	sys_acquire_spinlock(&mouse_thread_alive);
	puts("mouse dtor");
}

MouseDevice	myMouse;

IPointerDevice* CreateMouseObject(){
	return (IPointerDevice*)&myMouse;
}
