//
//	Interface for Pointer Device
//
#ifndef	_I_POINTER_DEVICE_H
#define	_I_POINTER_DEVICE_H

#include <pekoe.h>
#include <sys/gbc.h>

class PointerEventHandler {
public:
	virtual	void OnMove(int,int)=0;
	virtual	void OnButtonDown(uint32,uint32)=0;
	virtual	void OnButtonUp(uint32,uint32)=0;
};

class IPointerDevice {
protected:
	byte*	cursor;
	PointerEventHandler*	delegate;
	int32	x,y,w,h;
	uint32	button;
	int		dispflag;
public:
	IPointerDevice():cursor(0),delegate(0),x(0),y(0),w(0),h(0),button(0),dispflag(0){}
	virtual	~IPointerDevice()=0;
	inline	void	setEventHandler(PointerEventHandler* p){ delegate=p; }
	inline	void	setBound(int32 x1,int32 y1){ w=x1,h=y1; }
	inline	int32	get_X(){ return x; }
	inline	int32	get_Y(){ return y; }
	inline	byte*	set_Cursor(byte* p){ return cursor=p; }
	inline	byte*	get_Cursor(){ return cursor; }
	inline	int		set_Display(int f){ if(!(dispflag=f)) gbc_restore_cursor_block(); return dispflag; }
	inline	int		get_Display(){ return dispflag; }
};

extern	IPointerDevice* CreateMouseObject(void);

#endif
