package jp.ossc.petstore.peer.impl;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.peer.impl.BasePeer;
import jp.ossc.petstore.dto.BaseDTO;
import jp.ossc.petstore.function.ICategoryFanction;
import jp.ossc.petstore.function.IProductFunction;
import jp.ossc.petstore.dto.peerdto.ShowProductDefaultPeerDTO;
import jp.ossc.petstore.dto.functiondto.CategoryFunctionDTO;
import jp.ossc.petstore.dto.functiondto.ProductFunctionDTO;

/**
 * iꗗftHg\peerNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class ShowProductDefaultPeer extends BasePeer implements IPeer {

	/**
	 * JeSt@NV
	 */
	private ICategoryFanction categoryFunction;
	
	/**
	 * JeSt@NVݒ
	 * @param categoryFunction JeSt@NV
	 */
	public void setCategoryFunction(ICategoryFanction categoryFunction) {
		this.categoryFunction = categoryFunction;
	}

	/**
	 * it@NV
	 */
	private IProductFunction productFunction;
	
	/**
	 * it@NVݒ
	 * @param productFunction it@NV
	 */
	public void setProductFunction(IProductFunction productFunction) {
		this.productFunction = productFunction;
	}

	/**
	 * iꗗftHg\Ɩs<br>
	 * ŏ̃JeShc擾B<br>
	 * JeShc擾łȂꍇAG[bZ[Wݒ肵IB<br>
	 * 擾JeShcƂɏi񃊃Xg擾B<br>
	 * i񃊃Xg擾łȂꍇAG[bZ[Wݒ肵IB<br>
	 * @param dto DTOIuWFNg
	 */
	public void execute(BaseDTO dto) {
		
		// DTOLXg
		ShowProductDefaultPeerDTO showProductDefaultPeerDTO = (ShowProductDefaultPeerDTO)dto;
		
		// CategoryFunctionDTO
		CategoryFunctionDTO categoryFunctionDTO = new CategoryFunctionDTO();

		// ŏJeShc擾
		categoryFunction.getMinCategoryId(categoryFunctionDTO);
		
		// Xe[^X`FbN
		if (categoryFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			showProductDefaultPeerDTO.setStatus(categoryFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("errors.category_not_exist");
			ActionMessages msgs = new ActionMessages();
			msgs.add("ShowProductDefault", msg);
			showProductDefaultPeerDTO.setActionMessages(msgs);

			return;
		}
		
		// ŏJeShc
		String categoryId = categoryFunctionDTO.getCategoryId();
		
		// ProductFunctionDTO
		ProductFunctionDTO productFunctionDTO = new ProductFunctionDTO();
		productFunctionDTO.setCategoryId(categoryId);
		
		// iꗗ擾
		productFunction.getProductList(productFunctionDTO);
		
		// Xe[^X`FbN
		if (productFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			showProductDefaultPeerDTO.setStatus(productFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("errors.category.product_not_exist", categoryId);
			ActionMessages msgs = new ActionMessages();
			msgs.add("ShowProductDefault", msg);
			showProductDefaultPeerDTO.setActionMessages(msgs);

			return;
		}

		// iꗗݒ
		showProductDefaultPeerDTO.setProductList(productFunctionDTO.getProductList());
	}

}
