package jp.ossc.petstore.peer.impl;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import jp.ossc.petstore.common.Cart;
import jp.ossc.petstore.common.CartItem;
import jp.ossc.petstore.dto.BaseDTO;
import jp.ossc.petstore.dto.peerdto.OrderPeerDTO;
import jp.ossc.petstore.dto.functiondto.CustomerFunctionDTO;
import jp.ossc.petstore.dto.functiondto.ProductFunctionDTO;
import jp.ossc.petstore.dto.functiondto.OrderFunctionDTO;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.peer.impl.BasePeer;
import jp.ossc.petstore.function.IOrderFunction;
import jp.ossc.petstore.function.ICustomerFunction;
import jp.ossc.petstore.function.IProductFunction;
import jp.ossc.petstore.OpenstandiaConst;

/**
 * peerNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class OrderPeer extends BasePeer implements IPeer {

	/**
	 * O
	 */
	private static final Log LOG = LogFactory.getLog(OrderPeer.class);

	/**
	 * ca݃`FbNG[Oo͕@ڋq
	 */
	private static final String DATA_NOT_FOUND_CUSTOMER = "ڋq񂪑݂܂BڋqhcF";

	/**
	 * ca݃`FbNG[Oo͕@i
	 */
	private static final String DATA_NOT_FOUND_PRODUCT = "i񂪑݂܂BihcF";
	
	/**
	 * t@NV
	 */
	private IOrderFunction orderFunction;
	
	/**
	 * ڋqt@NV
	 */
	private ICustomerFunction customerFunction;
	
	/**
	 * it@NV
	 */
	private IProductFunction productFunction;


	/**
	 * t@NVݒ
	 * @param orderFunction t@NV
	 */
	public void setOrderFunction(IOrderFunction orderFunction) {
		this.orderFunction = orderFunction;
	}

	/**
	 * ڋqt@NVݒ
	 * @param customerFunction ڋqt@NV
	 */
	public void setCustomerFunction(ICustomerFunction customerFunction) {
		this.customerFunction = customerFunction;
	}

	/**
	 * it@NVݒ
	 * @param productFunction it@NV
	 */
	public void setProductFunction(IProductFunction productFunction) {
		this.productFunction = productFunction;
	}

	
	/**
	 * Ɩs<br>
	 * ȉ̏sB`FbNG[̓G[bZ[Wݒ肵IB
	 * <li>ڋq̑݃`FbNB
	 * <li>ȋ݃`FbNB
	 * <li>̓o^B
	 * @param dto DTOIuWFNg
	 */
	public void execute(BaseDTO dto) {
		
		// PeerDTO
		OrderPeerDTO orderPeerDTO = (OrderPeerDTO)dto;
		
		
		////////// ڋq񑶍݃`FbN //////////
		
		// [Uhc擾
		String userId = String.valueOf(orderPeerDTO.getCustomer().getId());
		
		// DTO
		CustomerFunctionDTO customerFunctionDTO = new CustomerFunctionDTO();
		customerFunctionDTO.setUserId(userId);
		
		// ڋq擾
		customerFunction.getCustomer(customerFunctionDTO);
		
		// Xe[^X`FbN
		if (customerFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			orderPeerDTO.setStatus(customerFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("exception.data");
			ActionMessages msgs = new ActionMessages();
			msgs.add("Customer", msg);
			orderPeerDTO.setActionMessages(msgs);

			// Oo
			LOG.error(DATA_NOT_FOUND_CUSTOMER + userId);
			
			return;
		}
		
		////////// i񑶍݃`FbN //////////
		
		// J[g擾
		Cart cart = orderPeerDTO.getCart();
		
		// J[gACeXg擾
		List<CartItem> list = cart.getItemList();
		
		// J[gACeXgAi񑶍݃`FbNs
		ProductFunctionDTO productFunctionDTO = null;
		String productId = null;
		for (CartItem item : list) {
			
			// DTO
			productFunctionDTO = new ProductFunctionDTO();
			productId = String.valueOf(item.getId());
			productFunctionDTO.setProductId(productId);
			
			// i擾
			productFunction.getProduct(productFunctionDTO);
			
			// Xe[^X`FbN
			if (productFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
				
				// Xe[^Xݒ
				orderPeerDTO.setStatus(productFunctionDTO.getStatus());

				// G[bZ[Wݒ
				ActionMessage msg = new ActionMessage("exception.data");
				ActionMessages msgs = new ActionMessages();
				msgs.add("Product", msg);
				orderPeerDTO.setActionMessages(msgs);

				// Oo
				LOG.error(DATA_NOT_FOUND_PRODUCT + productId);

				return;
			}
		}
		
		////////// o^ //////////
		
		// DTO
		OrderFunctionDTO orderFunctionDTO = new OrderFunctionDTO();
		orderFunctionDTO.setCustomer(orderPeerDTO.getCustomer());
		orderFunctionDTO.setCart(orderPeerDTO.getCart());
		
		// o^
		orderFunction.insertOrder(orderFunctionDTO);
		
		// hcݒ
		orderPeerDTO.setOrderId(orderFunctionDTO.getOrderId());
	}

}
