package jp.ossc.petstore.function.impl;

import java.util.List;

import jp.ossc.petstore.function.IProductFunction;
import jp.ossc.petstore.function.impl.BaseFunction;
import jp.ossc.petstore.model.Product;
import jp.ossc.petstore.dao.IProductDAO;
import jp.ossc.petstore.dto.functiondto.ProductFunctionDTO;
import jp.ossc.petstore.OpenstandiaConst;


/**
 * it@NVNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class ProductFunction extends BaseFunction implements IProductFunction {

	/**
	 * ic`n
	 */
	private IProductDAO productDAO;

	/**
	 * ic`nݒ
	 * @param productDAO ic`n
	 */
	public void setProductDAO(IProductDAO productDAO) {
		this.productDAO = productDAO;
	}


	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.IProductFunction#getProduct(jp.ossc.petstore.dto.functiondto.ProductFunctionDTO)
	 */
	public void getProduct(ProductFunctionDTO dto) {

		String productId = dto.getProductId();
		Product product = productDAO.getProduct(productId);
		
		if (product == null) {
			// Xe[^Xݒ
			dto.setStatus(OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND);
		}
		
		dto.setProduct(product);
	}


	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.IProductFunction#getProductList(jp.ossc.petstore.dto.functiondto.ProductFunctionDTO)
	 */
	public void getProductList(ProductFunctionDTO dto) {
		
		String categoryId = dto.getCategoryId();
		List list = productDAO.getProductList(categoryId);
		
		if (list.isEmpty()) {
			// Xe[^Xݒ
			dto.setStatus(OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND);
		}
		
		dto.setProductList(list);
	}

}
