package jp.ossc.petstore.dao.impl;

import java.util.List;

import jp.ossc.petstore.dao.ICustomerDAO;
import jp.ossc.petstore.dao.impl.BaseDAO;
import jp.ossc.petstore.model.Customer;

/**
 * ڋqe[uANZXNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class CustomerDAO extends BaseDAO implements ICustomerDAO {

	private static final String HQL_GET_CUSTOMER =
		"from Customer where id = ? and password = ?";
	
	
	/* ( Javadoc)
	 * @see jp.ossc.petstore.dao.ICustomerDAO#getCustomer(String,String)
	 */
	public Customer getCustomer(String userId, String password) {
		
		Customer customer = null;

		// p[^ݒ
		Object[] params = new Object[]{
				new Integer(userId),
				password};

		// ڋq擾
		List list = getHibernateTemplate().find(HQL_GET_CUSTOMER, params);
		
		// 擾R[hP̏ꍇ̂݌ʂԋp
		if (list.size() == 1) {
			customer = (Customer)list.get(0);
		}
		
		return customer;
	}


	/* ( Javadoc)
	 * @see jp.ossc.petstore.dao.ICustomerDAO#getCustomer(java.lang.String)
	 */
	public Customer getCustomer(String userId) {
		return (Customer)getHibernateTemplate().get(Customer.class, new Integer(userId));
	}

}
