/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int m_rmid = -1;
    private String m_xaOpenString = null;
    private static boolean s_libraryLoaded = false;
    private static final String s_dbSuffix = "HeteroXA";
    private static final String s_dllName = "heteroxa10";
    private static final char at_sign_char = '@';
    private static int s_rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;
    private String sDriverCharSetId = null;
    private String oldTnsEntry = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.m_user, this.m_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        try {
            String string3 = this.getURL();
            if (this.m_nativeXA && (string3.startsWith("jdbc:oracle:oci8") || string3.startsWith("jdbc:oracle:oci"))) {
                short s;
                Object object;
                long[] lArray = new long[]{0L, 0L};
                Properties properties = new Properties();
                String string4 = null;
                string4 = this.m_tnsentry != null ? this.m_tnsentry : this.getTNSEntryFromUrl(string3);
                if (string4 != null && string4.length() == 0 || string4.startsWith("(DESCRIPTION")) {
                    DatabaseError.throwSqlException(207);
                }
                if (!s_libraryLoaded) {
                    object = this.getClass();
                    synchronized (object) {
                        if (!s_libraryLoaded) {
                            try {
                                System.loadLibrary(s_dllName);
                                s_libraryLoaded = true;
                            }
                            catch (Error error) {
                                s_libraryLoaded = false;
                                throw error;
                            }
                        }
                    }
                }
                object = null;
                if (this.m_connectionProperties != null) {
                    object = this.m_connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                }
                if (object != null && ((String)object).equalsIgnoreCase("true")) {
                    s = T2CConnection.getDriverCharSetIdFromNLS_LANG(null);
                    this.sDriverCharSetId = Integer.toString(s);
                } else if (!string4.equals(this.oldTnsEntry)) {
                    s = T2CConnection.getCharSetIds(this.m_user, this.m_password, null, string4, 0, null, null);
                    this.sDriverCharSetId = Integer.toString(s);
                    this.oldTnsEntry = string4;
                }
                String string5 = this.m_databaseName + s_dbSuffix + s_rmidSeed;
                this.m_rmid = s_rmidSeed;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    s_rmidSeed = (s_rmidSeed + 1) % 65536;
                }
                int n = 0;
                String string6 = this.m_connectionProperties != null ? this.m_connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                this.m_xaOpenString = this.generateXAOpenString(string5, string4, this.m_user, this.m_password, 60, 2000, true, true, ".", n, false, string6 != null && string6.equalsIgnoreCase("true"), this.sDriverCharSetId, this.sDriverCharSetId);
                String string7 = this.generateXACloseString(string5, false);
                int n2 = this.do_xa_open(this.m_xaOpenString, this.m_rmid, 0, 0);
                if (n2 != 0) {
                    DatabaseError.throwSqlException(-1 * n2);
                }
                if ((n2 = this.convert_oci_handles(string5, lArray)) != 0) {
                    DatabaseError.throwSqlException(-1 * n2);
                }
                properties.put("user", this.m_user);
                properties.put("password", this.m_password);
                properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                properties.put("JDBCDriverCharSetId", this.sDriverCharSetId);
                if (this.m_loginTimeout != 0) {
                    properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.m_loginTimeout);
                }
                Connection connection = this.m_od.connect(this.getURL(), properties);
                OracleXAHeteroConnection oracleXAHeteroConnection = new OracleXAHeteroConnection(connection);
                oracleXAHeteroConnection.setRmid(this.m_rmid);
                oracleXAHeteroConnection.setXaCloseString(string7);
                oracleXAHeteroConnection.registerCloseCallback(new OracleXAHeteroCloseCallback(), oracleXAHeteroConnection);
                return oracleXAHeteroConnection;
            }
            if (this.thin_native_xa && string3.startsWith("jdbc:oracle:thin")) {
                Serializable serializable = this.getClass();
                synchronized (serializable) {
                    s_rmidSeed = (s_rmidSeed + 1) % 65536;
                }
                this.m_rmid = s_rmidSeed;
                if (this.m_connectionProperties == null) {
                    this.m_connectionProperties = new Properties();
                }
                this.m_connectionProperties.put("RessourceManagerId", Integer.toString(this.m_rmid));
                serializable = new T4CXAConnection(super.getPhysicalConnection(string, string2));
                String string8 = this.m_connectionProperties != null ? this.m_connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                ((OracleXAConnection)serializable).isXAResourceTransLoose = string8 != null && (string8.equals("true") || string8.equalsIgnoreCase("true"));
                return serializable;
            }
            OracleXAConnection oracleXAConnection = new OracleXAConnection(super.getPhysicalConnection(string, string2));
            String string9 = this.m_connectionProperties != null ? this.m_connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            oracleXAConnection.isXAResourceTransLoose = string9 != null && (string9.equals("true") || string9.equalsIgnoreCase("true"));
            return oracleXAConnection;
        }
        catch (XAException xAException) {
            return null;
        }
    }

    private native int do_xa_open(String var1, int var2, int var3, int var4);

    private native int convert_oci_handles(String var1, long[] var2);

    synchronized void setRmid(int n) {
        this.m_rmid = n;
    }

    synchronized int getRmid() {
        return this.m_rmid;
    }

    synchronized void setXaOpenString(String string) {
        this.m_xaOpenString = string;
    }

    synchronized String getXaOpenString() {
        return this.m_xaOpenString;
    }

    private String generateXAOpenString(String string, String string2, String string3, String string4, int n, int n2, boolean bl, boolean bl2, String string5, int n3, boolean bl3, boolean bl4, String string6, String string7) {
        return new String("ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n2 + "+SESWT=" + n + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n3 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f") + (bl4 ? "+Loose_Coupling=t" : "") + "+CharSet=" + string6 + "+NCharSet=" + string7);
    }

    private String generateXACloseString(String string, boolean bl) {
        return new String("ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String getTNSEntryFromUrl(String string) {
        int n = string.indexOf(64);
        return string.substring(n + 1);
    }
}

