/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;

class OracleTimeoutThreadPerVM
extends OracleTimeout {
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    OracleTimeoutThreadPerVM(String string) {
        this.name = string;
        this.interruptAfter = Long.MAX_VALUE;
        watchdog.addTimeout(this);
    }

    void close() {
        watchdog.removeTimeout(this);
    }

    synchronized void setTimeout(long l, OracleStatement oracleStatement) throws SQLException {
        if (this.interruptAfter != Long.MAX_VALUE) {
            DatabaseError.throwSqlException(131);
        }
        this.statement = oracleStatement;
        this.interruptAfter = System.currentTimeMillis() + l;
    }

    synchronized void cancelTimeout() throws SQLException {
        this.statement = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfAppropriate(long l) {
        if (l > this.interruptAfter) {
            OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = this;
            synchronized (oracleTimeoutThreadPerVM) {
                if (l > this.interruptAfter) {
                    try {
                        this.statement.cancel();
                        this.statement = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        }
    }
}

