/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;

public class QrcodeImage
extends Component {
    private static final String VERSION = "7.2.1.0 (2020/03/13)";
    private static final long serialVersionUID = 721020200313L;
    private static final int[][][] QC_DATA = new int[][][]{new int[][]{{17, 10, 4}, {34, 20, 8}}, new int[][]{{34, 20, 8}, {63, 38, 16}}, new int[][]{{58, 35, 15}, {101, 61, 26}}, new int[][]{{82, 50, 21}, {149, 90, 38}}, new int[][]{{106, 64, 27}, {202, 122, 52}}, new int[][]{{139, 84, 36}, {255, 154, 65}}, new int[][]{{154, 93, 39}, {293, 178, 75}}, new int[][]{{202, 122, 52}, {365, 221, 93}}, new int[][]{{235, 143, 60}, {432, 262, 111}}, new int[][]{{288, 174, 74}, {513, 311, 131}}, new int[][]{{331, 200, 85}, {604, 366, 155}}, new int[][]{{374, 227, 96}, {691, 419, 177}}, new int[][]{{427, 259, 109}, {796, 483, 204}}, new int[][]{{468, 283, 120}, {871, 528, 223}}, new int[][]{{530, 321, 136}, {991, 600, 254}}, new int[][]{{602, 365, 154}, {1082, 656, 277}}, new int[][]{{674, 408, 173}, {1212, 734, 310}}, new int[][]{{746, 452, 191}, {1346, 816, 345}}, new int[][]{{813, 493, 208}, {1500, 909, 384}}, new int[][]{{919, 557, 235}, {1600, 970, 410}}, new int[][]{{969, 587, 248}, {1708, 1035, 438}}, new int[][]{{1056, 640, 270}, {1872, 1134, 480}}, new int[][]{{1108, 672, 284}, {2059, 1248, 528}}, new int[][]{{1228, 744, 315}, {2188, 1326, 561}}, new int[][]{{1286, 779, 330}, {2395, 1451, 614}}, new int[][]{{1425, 864, 365}, {2544, 1542, 652}}, new int[][]{{1501, 910, 385}, {2701, 1637, 692}}, new int[][]{{1581, 958, 405}, {2857, 1732, 732}}, new int[][]{{1677, 1016, 430}, {3035, 1839, 778}}, new int[][]{{1782, 1080, 457}, {3289, 1994, 843}}, new int[][]{{1897, 1150, 486}, {3486, 2113, 894}}, new int[][]{{2022, 1226, 518}, {3693, 2238, 947}}, new int[][]{{2157, 1307, 553}, {3909, 2369, 1002}}, new int[][]{{2301, 1394, 590}, {4134, 2506, 1060}}, new int[][]{{2361, 1431, 605}, {4343, 2632, 1113}}, new int[][]{{2524, 1530, 647}, {4588, 2780, 1176}}, new int[][]{{2625, 1591, 673}, {4775, 2894, 1224}}, new int[][]{{2735, 1658, 701}, {5039, 3054, 1292}}, new int[][]{{2927, 1774, 750}, {5313, 3220, 1362}}, new int[][]{{3057, 1852, 784}, {5596, 3391, 1435}}};
    public static final int DEF_VERSION = 5;
    public static final int MARGIN = 4;
    public static final int PIXEL = 3;
    public static final String IMAGE_TYPE = "PNG";
    private String qrData;
    private String saveFile;
    private String imgType = "PNG";
    private ErrCrct errCo = ErrCrct.DEF;
    private EncMode encMd = EncMode.DEF;
    private int version = 5;
    private int pixel = 3;
    private String txtEnc;
    private int imageSize;

    public void init(String string, String string2) {
        this.init(string, string2, 5, EncMode.DEF, ErrCrct.DEF, IMAGE_TYPE, 3, this.txtEnc);
    }

    public void init(String string, String string2, int n, EncMode encMode) {
        this.init(string, string2, n, encMode, ErrCrct.DEF, IMAGE_TYPE, 3, this.txtEnc);
    }

    public void init(String string, String string2, int n, EncMode encMode, ErrCrct errCrct, String string3, int n2, String string4) {
        this.qrData = string;
        this.saveFile = string2;
        this.imgType = string3;
        this.errCo = errCrct;
        this.encMd = encMode;
        this.version = n;
        this.pixel = n2;
        this.txtEnc = string4;
        this.imageSize = (25 + n * 4) * n2;
    }

    @Override
    public void paint(Graphics graphics) {
        Qrcode qrcode = new Qrcode();
        qrcode.setQrcodeErrorCorrect(this.errCo.getCh());
        qrcode.setQrcodeEncodeMode(this.encMd.getCh());
        qrcode.setQrcodeVersion(this.version);
        Charset charset = this.txtEnc == null || this.txtEnc.isEmpty() ? HybsConst.DEFAULT_CHARSET : ("UTF-8".equals(this.txtEnc) ? StandardCharsets.UTF_8 : Charset.forName(this.txtEnc));
        byte[] byArray = this.qrData.getBytes(charset);
        boolean[][] blArray = qrcode.calQrcode(byArray);
        int n = blArray.length;
        int n2 = 4 * this.pixel;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!blArray[j][i]) continue;
                graphics.fillRect(n2 + j * this.pixel, n2 + i * this.pixel, this.pixel, this.pixel);
            }
        }
    }

    public void saveImage() {
        BufferedImage bufferedImage = new BufferedImage(this.imageSize, this.imageSize, 4);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.imageSize, this.imageSize);
        graphics.setColor(Color.BLACK);
        this.paint(graphics);
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, this.imgType, new File(this.saveFile));
        }
        catch (IOException iOException) {
            String string = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + this.saveFile + "]";
            throw new OgRuntimeException(string, iOException);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.QrcodeImage Encode [SaevFile]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray.length > 1 ? stringArray[1] : "img.png";
        QrcodeImage qrcodeImage = new QrcodeImage();
        qrcodeImage.init(string, string2);
        qrcodeImage.saveImage();
    }

    public static void printQcData() {
        char[] cArray = new char[]{'L', 'M', 'Q', 'H'};
        char[] cArray2 = new char[]{'N', 'A', 'B'};
        for (int i = 0; i < QC_DATA.length; ++i) {
            System.out.print("version=[" + (i + 1) + "] ");
            for (int j = 0; j < QC_DATA[i].length; ++j) {
                char c = cArray[j];
                for (int k = 0; k < QC_DATA[i][j].length; ++k) {
                    System.out.print(c + cArray2[k] + "=[" + QC_DATA[i][j][k] + "] ");
                }
            }
            System.out.println();
        }
    }

    public static int getVersion(ErrCrct errCrct, EncMode encMode, int n) {
        int n2 = errCrct.getNo();
        int n3 = encMode.getNo();
        int n4 = -1;
        for (int i = 0; i < QC_DATA.length; ++i) {
            if (QC_DATA[i][n2][n3] < n) continue;
            n4 = i;
            break;
        }
        if (n4 < 0) {
            String string = "\u30c7\u30fc\u30bf\u91cf\u304c\u5bfe\u8c61\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002\u30a8\u30e9\u30fc\u30ec\u30d9\u30eb\u3084\u3001\u30e2\u30fc\u30c9\u3092\u8abf\u6574\u3057\u3066\u304f\u3060\u3055\u3044\u3002ErrCo:" + errCrct + " EncMd:" + encMode + " len=[" + n + "] MaxLen=[" + QC_DATA[QC_DATA.length - 1][n2][n3] + "]";
            throw new OgRuntimeException(string);
        }
        return n4 + 1;
    }

    public static int getMaxSize(int n, ErrCrct errCrct, EncMode encMode) {
        int n2 = errCrct.getNo();
        int n3 = encMode.getNo();
        return QC_DATA[n][n2][n3];
    }

    public static enum EncMode {
        N(0),
        A(1),
        B(1);

        private int no;
        public static final EncMode DEF;

        private EncMode(int n2) {
            this.no = n2;
        }

        public int getNo() {
            return this.no;
        }

        public char getCh() {
            char c;
            switch (this) {
                case N: {
                    c = 'N';
                    break;
                }
                case A: {
                    c = 'A';
                    break;
                }
                default: {
                    c = 'B';
                }
            }
            return c;
        }

        public static EncMode get(char c) {
            EncMode encMode;
            switch (c) {
                case 'N': {
                    encMode = N;
                    break;
                }
                case 'A': {
                    encMode = A;
                    break;
                }
                default: {
                    encMode = B;
                }
            }
            return encMode;
        }

        static {
            DEF = B;
        }
    }

    public static enum ErrCrct {
        L(1),
        M(0),
        Q(3),
        H(2);

        private int no;
        public static final ErrCrct DEF;

        private ErrCrct(int n2) {
            this.no = n2;
        }

        public int getNo() {
            return this.no;
        }

        public char getCh() {
            char c;
            switch (this) {
                case L: {
                    c = 'L';
                    break;
                }
                case Q: {
                    c = 'Q';
                    break;
                }
                case H: {
                    c = 'H';
                    break;
                }
                default: {
                    c = 'M';
                }
            }
            return c;
        }

        public static ErrCrct get(char c) {
            ErrCrct errCrct;
            switch (c) {
                case 'L': {
                    errCrct = L;
                    break;
                }
                case 'Q': {
                    errCrct = Q;
                    break;
                }
                case 'H': {
                    errCrct = H;
                    break;
                }
                default: {
                    errCrct = M;
                }
            }
            return errCrct;
        }

        static {
            DEF = M;
        }
    }
}

