/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgCharacterException;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;

public class Process_TableDiff
extends AbstractProcess
implements FirstProcess {
    private static final String ENCODE = System.getProperty("file.encoding");
    private char separator1 = (char)9;
    private char separator2 = (char)9;
    private String infile1;
    private String encode1;
    private String infile2;
    private BufferedReader reader1;
    private LineModel model;
    private String line;
    private int[] clmNos;
    private int[] keyClmNos;
    private int[] diffClmNos;
    private String actCmnd;
    private boolean display;
    private boolean debug;
    private boolean nameNull;
    private final ConcurrentMap<String, String> file2Map = new ConcurrentHashMap<String, String>();
    private int inCount1;
    private int inCount2;
    private int outCount;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY;

    public Process_TableDiff() {
        super("org.opengion.fukurou.process.Process_TableDiff", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        String[] stringArray;
        Argument argument = this.getArgument();
        this.infile1 = argument.getProparty("infile1");
        this.encode1 = argument.getProparty("encode1", ENCODE);
        this.infile2 = argument.getProparty("infile2");
        this.actCmnd = argument.getProparty("action");
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        String string = argument.getProparty("sep1", null);
        String string2 = argument.getProparty("sep2", null);
        if (string != null) {
            this.separator1 = string.charAt(0);
        }
        if (string2 != null) {
            this.separator2 = string2.charAt(0);
        }
        if (this.infile1 == null || this.infile2 == null) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002File1=[" + this.infile1 + "] , File2=[" + this.infile2 + "]";
            throw new OgRuntimeException(string3);
        }
        File file = new File(this.infile1);
        File file2 = new File(this.infile2);
        if (!file.exists() || !file2.exists()) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + (String)(file.exists() ? "" : "File1=[" + file + "] ") + (String)(file2.exists() ? "" : "File2=[" + file2 + "]");
            throw new OgRuntimeException(string4);
        }
        if (!file.isFile() || !file2.isFile()) {
            String string5 = "\u30d5\u30a9\u30eb\u30c0\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + (String)(file.isFile() ? "" : "File1=[" + file + "] ") + (String)(file2.isFile() ? "" : "File2=[" + file2 + "]");
            throw new OgRuntimeException(string5);
        }
        this.reader1 = FileUtil.getBufferedReader(file, this.encode1);
        String string6 = argument.getProparty("columns");
        if (string6 == null) {
            String[] stringArray2 = this.readName(this.reader1);
            if (stringArray2 == null || stringArray2.length == 0) {
                this.nameNull = true;
                return;
            }
            stringArray = stringArray2;
        } else {
            stringArray = StringUtil.csv2Array(string6);
        }
        this.model = new LineModel();
        this.model.init(stringArray);
        if (this.display) {
            this.println(this.model.nameLine());
        }
        this.clmNos = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.clmNos[i] = i + 1;
        }
        String string7 = argument.getProparty("keyClms");
        if (this.debug) {
            this.println("DEBUG:\tkeyClms=" + string7);
        }
        String[] stringArray3 = StringUtil.csv2Array(string7);
        this.keyClmNos = new int[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            this.keyClmNos[i] = this.model.getColumnNo(stringArray3[i]);
        }
        String string8 = argument.getProparty("diffClms");
        if (this.debug) {
            this.println("DEBUG:\tdiffClms=" + string8);
        }
        String[] stringArray4 = StringUtil.csv2Array(string8);
        this.diffClmNos = new int[stringArray4.length];
        for (int i = 0; i < stringArray4.length; ++i) {
            this.diffClmNos[i] = this.model.getColumnNo(stringArray4[i]);
        }
        String string9 = argument.getProparty("encode2", ENCODE);
        this.readF2Data(file2, string9);
    }

    @Override
    public void end(boolean bl) {
        Closer.ioClose(this.reader1);
        this.reader1 = null;
    }

    @Override
    public boolean next() {
        if (this.nameNull) {
            return false;
        }
        boolean bl = false;
        try {
            while ((this.line = this.reader1.readLine()) != null) {
                ++this.inCount1;
                if (this.line.isEmpty() || this.line.charAt(0) == '#') continue;
                bl = true;
                break;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + CR + " [" + this.infile1 + "] , Encode=[" + this.encode1 + "]";
            throw new OgCharacterException(string, characterCodingException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.infile1 + "]:(" + this.inCount1 + ")";
            throw new OgRuntimeException(string, iOException);
        }
        return bl;
    }

    @Override
    public LineModel makeLineModel(int n) {
        ++this.outCount;
        String[] stringArray = StringUtil.csv2Array(this.line, this.separator1);
        int n2 = stringArray.length;
        for (int i = 0; i < this.model.size(); ++i) {
            int n3 = this.clmNos[i];
            if (n2 > n3) {
                this.model.setValue(i, stringArray[n3]);
                continue;
            }
            this.model.setValue(i, "");
        }
        this.model.setRowNo(n);
        return this.action(this.model);
    }

    private LineModel action(LineModel lineModel) {
        LineModel lineModel2 = null;
        Object[] objectArray = lineModel.getValues();
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.keyClmNos.length; ++i) {
            stringBuilder.append(objectArray[this.keyClmNos[i]]).append(',');
        }
        String string = (String)this.file2Map.get(stringBuilder.toString());
        if ("ONLY".equalsIgnoreCase(this.actCmnd) && string == null) {
            if (this.debug) {
                this.println("DEBUG:ONLY\t" + stringBuilder.toString());
            }
            lineModel2 = lineModel;
        } else {
            int n;
            StringBuilder stringBuilder2 = new StringBuilder(200);
            for (n = 0; n < this.diffClmNos.length; ++n) {
                stringBuilder2.append(objectArray[this.diffClmNos[n]]).append(',');
            }
            n = stringBuilder2.toString().equals(string) ? 1 : 0;
            if ("DIFF".equalsIgnoreCase(this.actCmnd) && n == 0) {
                if (this.debug) {
                    this.println("DEBUG:DIFF\t" + stringBuilder.toString() + "\t" + string + "\t" + stringBuilder2.toString());
                }
                lineModel2 = lineModel;
            } else if ("INTERSEC".equalsIgnoreCase(this.actCmnd) && n != 0) {
                if (this.debug) {
                    this.println("DEBUG:INTERSEC\t" + stringBuilder.toString() + "\t" + string);
                }
                lineModel2 = lineModel;
            }
        }
        if (this.display && lineModel2 != null) {
            this.println(lineModel2.dataLine());
        }
        return lineModel2;
    }

    private String[] readName(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                ++this.inCount1;
                if (string.isEmpty()) continue;
                if (string.charAt(0) == '#') {
                    if (string.length() < 5 || !"#NAME".equalsIgnoreCase(string.substring(0, 5))) continue;
                    char c = '\t' != this.separator1 && string.indexOf(this.separator1) >= 0 ? this.separator1 : (char)'\t';
                    return StringUtil.csv2Array(string.substring(6), c);
                }
                throw new OgRuntimeException("#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002");
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + CR + " [" + this.infile1 + "] , Encode=[" + this.encode1 + "]";
            throw new OgCharacterException(string, characterCodingException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.infile1 + "]:(" + this.inCount1 + ")";
            throw new OgRuntimeException(string, iOException);
        }
        return new String[0];
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readF2Data(File file, String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            if (this.debug) {
                this.println("DEBUG:\tFile2=" + file + " \u521d\u671f\u51e6\u7406");
            }
            bufferedReader = FileUtil.getBufferedReader(file, string);
            StringBuilder stringBuilder = new StringBuilder(200);
            StringBuilder stringBuilder2 = new StringBuilder(200);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                ++this.inCount2;
                if (string2.isEmpty() || string2.charAt(0) == '#') continue;
                String string3 = string2.substring(string2.indexOf(this.separator2) + 1);
                String[] stringArray = StringUtil.csv2Array(string3, this.separator2);
                stringBuilder.setLength(0);
                for (n = 0; n < this.keyClmNos.length; ++n) {
                    stringBuilder.append((Object)stringArray[this.keyClmNos[n]]).append(',');
                }
                stringBuilder2.setLength(0);
                for (n = 0; n < this.diffClmNos.length; ++n) {
                    stringBuilder2.append((Object)stringArray[this.diffClmNos[n]]).append(',');
                }
                if (this.debug) {
                    this.println("DEBUG:\t" + stringBuilder.toString() + "\t" + stringBuilder2.toString());
                }
                this.file2Map.put(stringBuilder.toString(), stringBuilder2.toString());
            }
            if (this.debug) {
                this.println("DEBUG:\t======\u521d\u671f\u51e6\u7406\u7d42\u4e86======");
            }
        }
        catch (CharacterCodingException characterCodingException) {
            try {
                String string4 = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + CR + " [" + file.getPath() + "] , Encode=[" + string + "]";
                throw new OgCharacterException(string4, characterCodingException);
                catch (IOException iOException) {
                    String string5 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file.getPath() + "]:(" + this.inCount2 + ")";
                    throw new OgRuntimeException(string5, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedReader);
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\tInput  File1  : " + this.infile1 + CR + "\tInput  File2  : " + this.infile2 + CR + "\tInput  Count1 : " + this.inCount1 + CR + "\tInput  Count2 : " + this.inCount2 + CR + "\tOutput Count  : " + this.outCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_TableDiff\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3092\u3001LineModel \u306b\u8a2d\u5b9a\u5f8c\u3001").append(CR).append("\u4e0b\u6d41\u306b\u6e21\u3059\u3001FirstProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("DBTableModel \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u53d6\u3063\u3066\u3001\u5404\u884c\u3092 LineModel \u306b\u30bb\u30c3\u30c8\u3057\u3066\u3001").append(CR).append("\u4e0b\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u306b\u6e21\u3055\u308c\u307e\u3059\u3002)\u306b\u6e21\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_TableDiff().usage());
    }

    static {
        MUST_PROPARTY.put("infile1", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d1 (\u5fc5\u9808)");
        MUST_PROPARTY.put("infile2", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d2 (\u5fc5\u9808)");
        MUST_PROPARTY.put("action", "(\u5fc5\u9808)ONLY,DIFF,INTERSEC");
        MUST_PROPARTY.put("keyClms", "\u6bd4\u8f03\u3059\u308b\u5217\u306e\u57fa\u6e96\u30ab\u30e9\u30e0\u540d(\u5fc5\u9808)(CSV\u5f62\u5f0f)");
        MUST_PROPARTY.put("diffClms", "\u6bd4\u8f03\u3059\u308b\u30ab\u30e9\u30e0\u540d(\u5fc5\u9808)(CSV\u5f62\u5f0f)");
        USABLE_PROPARTY = new LinkedHashMap<String, String>();
        USABLE_PROPARTY.put("sep1", "\u533a\u5207\u308a\u6587\u5b571 (\u521d\u671f\u5024:\u30bf\u30d6)");
        USABLE_PROPARTY.put("sep2", "\u533a\u5207\u308a\u6587\u5b572 (\u521d\u671f\u5024:\u30bf\u30d6)");
        USABLE_PROPARTY.put("encode1", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d71");
        USABLE_PROPARTY.put("encode2", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d72");
        USABLE_PROPARTY.put("columns", "\u5165\u529b\u30ab\u30e9\u30e0\u540d(CSV\u5f62\u5f0f)");
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + " (\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + " (\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

