/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.opengion.fukurou.fileexec.FileUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class BasePath {
    private static final XLogger LOGGER = XLogger.getLogger(BasePath.class.getName());
    public static final String CR = System.getProperty("line.separator");
    public static final String DEF_WORK_DIR = "work";
    public static final String DEF_OK_DIR = "bkup_ok";
    public static final String DEF_NG_DIR = "bkup_ng";
    public final Path BASE_PATH;
    public final Path SUB_PATH;
    public final Path WORK_PATH;
    public final Path OK_PATH;
    public final Path NG_PATH;
    private final Set<String> omitScanDir;

    public BasePath(String ... stringArray) {
        String string = stringArray[0];
        this.BASE_PATH = FileUtil.writePath(string, new String[0]);
        this.SUB_PATH = stringArray[1] == null || stringArray[1].isEmpty() ? this.BASE_PATH : FileUtil.writePath(string, stringArray[1]);
        this.WORK_PATH = this.makePath(string, stringArray[2], DEF_WORK_DIR);
        this.OK_PATH = this.makePath(string, stringArray[3], DEF_OK_DIR);
        this.NG_PATH = this.makePath(string, stringArray[4], DEF_NG_DIR);
        this.omitScanDir = new HashSet<String>();
        this.omitScanDir.add(this.OK_PATH.getFileName().toString());
        this.omitScanDir.add(this.OK_PATH.getFileName().toString());
        this.omitScanDir.add(this.NG_PATH.getFileName().toString());
        LOGGER.debug(() -> "\u2462 [BasePath]" + CR + "\t  BASE_PATH=" + this.BASE_PATH + CR + "\t  SUB_PATH =" + this.SUB_PATH + CR + "\t  WORK_PATH=" + this.WORK_PATH + CR + "\t  OK_PATH  =" + this.OK_PATH + CR + "\t  NG_PATH  =" + this.NG_PATH);
    }

    private Path makePath(String string, String string2, String string3) {
        return string2 == null || string2.isEmpty() ? FileUtil.writePath(string, string3) : (FileUtil.isAbsolute(string2) ? FileUtil.writePath(string2, new String[0]) : FileUtil.writePath(string, string2));
    }

    public boolean isScanPath(Path path) {
        String string = path.getFileName().toString();
        return !this.omitScanDir.contains(string);
    }
}

