<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9510"
	title	= "標準(ﾎﾟｯﾌﾟｱｯﾌﾟ用)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" minRowCount="0" />

<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	(CASE KBSAKU WHEN '0' THEN 0 ELSE 1 END) AS WRITABLE	<!-- 書込制御 -->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,LANG													<!-- 言語 -->
				,CLM													<!-- 項目 -->
				,NAME_JA												<!-- 名称(漢字) -->
				,LABEL_NAME												<!-- 表示名称 -->
				,KBSAKU													<!-- 作成区分 -->
				,CDTAN													<!-- 担当者 -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
		FROM	GF41
		WHERE	SYSTEM_ID = '{@SYSTEM_ID}'
		AND		UNIQ      = '{@UNIQ}'
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
  <span style="white-space:nowrap;" >
	<og:submit  action="ENTRY" />
	<og:submit  action="RESET" />
	<og:input   type="reset"  name="command"  lbl="MSG0011"  td="false" />
  </span>
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
<og:view
	viewFormType = "HTMLTextField" 
	command      = "{@command}" 
	noDisplay    = "UNIQ"
	noWritable	 = "SYSTEM_ID,CLM"
	noMessage    = "true"
/>

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />

</form>

<script type="text/javascript" >
	adjustFrameWidth();
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
