/*
 * Decompiled with CFR 0.152.
 */
package twitter.manage;

import java.io.StringReader;
import java.lang.constant.Constable;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import twitter.manage.SimpleStatus;
import twitter.manage.SimpleUser;
import twitter.util.HTMLEncode;
import twitter4j.Status;
import twitter4j.User;

public class StatusXMLConverter {
    private static final String ROOT_TAG = "root";
    private static final String TWEET_TAG = "tweet";
    private static final String DATE_TAG = "date";
    private static final String LOCATION_TAG = "location";
    private static final String ID_TAG = "id";
    private static final String CONTRIBUTOR_TAG = "contributor";
    private static final String CONTRIBUTOR_NAME_TAG = "contributorName";
    private static final String REPLY_TO_SCREEN_NAME_TAG = "replyToScreenName";
    private static final String REPLY_STATUS_ID_TAG = "replyStatusID";
    private static final String REPLY_USER_ID_TAG = "replyUserID";
    private static final String PLACE_TAG = "place";
    private static final String RETWEET_STATUS_TAG = "retweetStatus";
    private static final String TEXT_TAG = "text";
    private static final String FAVORITE_TAG = "favorite";
    private static final String RETWEET_TAG = "retweet";
    private static final String TRUNCATED_TAG = "truncated";
    private static final String SOURCE_TAG = "source";
    private static final String USER_TAG = "user";
    private static final String CREATED_AT_TAG = "created";
    private static final String DESCRIPTION_TAG = "description";
    private static final String FAVOURITES_TAG = "favourites";
    private static final String FOLLOWERS_TAG = "followers";
    private static final String FRIENDS_TAG = "friends";
    private static final String LANG_TAG = "lang";
    private static final String NAME_TAG = "name";
    private static final String PROFILE_BACKGROUND_COLOR_TAG = "profileBackgroundColor";
    private static final String PROFILE_BACKGROUND_IMAGE_URL_TAG = "profileBackgroundImageURL";
    private static final String PROFILE_IMAGE_URL = "profileImageURL";
    private static final String PROFILE_LINK_COLOR_TAG = "profileLinkColor";
    private static final String PROFILE_SIDEBAR_BORDER_COLOR_TAG = "profileSidebarBorderColor";
    private static final String PROFILE_SIDEBAR_FILL_COLOR_TAG = "profileSidebarFillColor";
    private static final String PROFILE_TEXT_COLOR_TAG = "profileTextColor";
    private static final String SCREEN_NAME = "screenName";
    private static final String STATUSES_COUNT_TAG = "statusesCount";
    private static final String TIMEZONE_TAG = "timeZone";
    private static final String URL_TAG = "url";
    private static final String UTCOFFSET_TAG = "utc";
    private static final String CONTRIBUTORS_ENABLE_TAG = "contributorsEnable";
    private static final String GEO_ENABLE_TAG = "geoEnable";
    private static final String PROFILE_BACKGROUND_TILED_TAG = "profileBackgroundTiled";
    private static final String PROTECTED_TAG = "protected";
    private static final String VERIFIED_TAG = "verified";
    private static final String DATE_PATTERN = "yyyy.MM.dd HH:mm:ss";

    public static String convertStatusToXML(Status status) {
        String[] contributor = status.getContributors();
        String date = null;
        if (status.getCreatedAt() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            date = sdf.format(status.getCreatedAt());
        }
        String location = null;
        if (status.getGeoLocation() != null) {
            location = status.getGeoLocation().toString();
        }
        long id = status.getId();
        String replyToScreenName = status.getInReplyToScreenName();
        long replyStatusID = status.getInReplyToStatusId();
        long replyUserID = status.getInReplyToUserId();
        String place = null;
        if (status.getPlace() != null) {
            place = status.getPlace().toString();
        }
        Status retweetStatus = status.getRetweetedStatus();
        String text = status.getText();
        User user = status.getUser();
        boolean favorite = status.isFavorited();
        boolean retweet = status.isRetweet();
        boolean truncated = status.isTruncated();
        String source = status.getSource();
        StringBuffer buf = new StringBuffer("");
        buf.append("<tweet>\n");
        if (contributor != null) {
            buf.append("<contributor>");
            String[] stringArray = contributor;
            int n = contributor.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                buf.append(StatusXMLConverter.createXMLTag(CONTRIBUTOR_NAME_TAG, HTMLEncode.encode(c)));
                ++n2;
            }
            buf.append("</contributor>");
        }
        if (date != null) {
            buf.append(StatusXMLConverter.createXMLTag(DATE_TAG, HTMLEncode.encode(date)));
        }
        if (location != null) {
            buf.append(StatusXMLConverter.createXMLTag(LOCATION_TAG, HTMLEncode.encode(location)));
        }
        buf.append(StatusXMLConverter.createXMLTag(ID_TAG, id));
        if (replyToScreenName != null) {
            buf.append(StatusXMLConverter.createXMLTag(REPLY_TO_SCREEN_NAME_TAG, HTMLEncode.encode(replyToScreenName)));
        }
        buf.append(StatusXMLConverter.createXMLTag(REPLY_STATUS_ID_TAG, replyStatusID));
        buf.append(StatusXMLConverter.createXMLTag(REPLY_USER_ID_TAG, replyUserID));
        if (place != null) {
            buf.append(StatusXMLConverter.createXMLTag(PLACE_TAG, HTMLEncode.encode(place)));
        }
        if (retweetStatus != null) {
            buf.append(StatusXMLConverter.createXMLTag(RETWEET_STATUS_TAG, StatusXMLConverter.convertStatusToXML(retweetStatus)));
        }
        if (text != null) {
            buf.append(StatusXMLConverter.createXMLTag(TEXT_TAG, HTMLEncode.encode(text)));
        }
        if (user != null) {
            buf.append(StatusXMLConverter.convertUserToXML(user));
        }
        if (source != null) {
            buf.append(StatusXMLConverter.createXMLTag(SOURCE_TAG, HTMLEncode.encode(source)));
        }
        buf.append(StatusXMLConverter.createXMLTag(FAVORITE_TAG, favorite));
        buf.append(StatusXMLConverter.createXMLTag(RETWEET_TAG, retweet));
        buf.append(StatusXMLConverter.createXMLTag(TRUNCATED_TAG, truncated));
        buf.append("</tweet>");
        return buf.toString();
    }

    public static String convertUserToXML(User user) {
        StringBuffer buf = new StringBuffer("");
        buf.append("<user>\n");
        if (user.getCreatedAt() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            buf.append(StatusXMLConverter.createXMLTag(CREATED_AT_TAG, sdf.format(user.getCreatedAt())));
        }
        if (user.getDescription() != null) {
            buf.append(StatusXMLConverter.createXMLTag(DESCRIPTION_TAG, HTMLEncode.encode(user.getDescription())));
        }
        buf.append(StatusXMLConverter.createXMLTag(FAVORITE_TAG, user.getFavouritesCount()));
        buf.append(StatusXMLConverter.createXMLTag(FOLLOWERS_TAG, user.getFollowersCount()));
        buf.append(StatusXMLConverter.createXMLTag(FRIENDS_TAG, user.getFriendsCount()));
        buf.append(StatusXMLConverter.createXMLTag(ID_TAG, user.getId()));
        if (user.getLang() != null) {
            buf.append(StatusXMLConverter.createXMLTag(LANG_TAG, HTMLEncode.encode(user.getLang())));
        }
        if (user.getLocation() != null) {
            buf.append(StatusXMLConverter.createXMLTag(LOCATION_TAG, HTMLEncode.encode(user.getLocation())));
        }
        if (user.getName() != null) {
            buf.append(StatusXMLConverter.createXMLTag(NAME_TAG, HTMLEncode.encode(user.getName())));
        }
        if (user.getProfileBackgroundColor() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_BACKGROUND_COLOR_TAG, HTMLEncode.encode(user.getProfileBackgroundColor())));
        }
        if (user.getProfileBackgroundImageUrl() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_BACKGROUND_IMAGE_URL_TAG, HTMLEncode.encode(user.getProfileBackgroundImageUrl())));
        }
        if (user.getProfileImageURL() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_IMAGE_URL, HTMLEncode.encode(user.getProfileImageURL().toString())));
        }
        if (user.getProfileBackgroundColor() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_BACKGROUND_COLOR_TAG, HTMLEncode.encode(user.getProfileBackgroundColor())));
        }
        if (user.getProfileSidebarBorderColor() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_SIDEBAR_BORDER_COLOR_TAG, HTMLEncode.encode(user.getProfileSidebarBorderColor())));
        }
        if (user.getProfileSidebarFillColor() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_SIDEBAR_FILL_COLOR_TAG, HTMLEncode.encode(user.getProfileSidebarFillColor())));
        }
        if (user.getProfileTextColor() != null) {
            buf.append(StatusXMLConverter.createXMLTag(PROFILE_TEXT_COLOR_TAG, HTMLEncode.encode(user.getProfileTextColor())));
        }
        if (user.getScreenName() != null) {
            buf.append(StatusXMLConverter.createXMLTag(SCREEN_NAME, HTMLEncode.encode(user.getScreenName())));
        }
        if (user.getStatus() != null) {
            buf.append(StatusXMLConverter.convertStatusToXML(user.getStatus()));
        }
        buf.append(StatusXMLConverter.createXMLTag(STATUSES_COUNT_TAG, user.getStatusesCount()));
        if (user.getTimeZone() != null) {
            buf.append(StatusXMLConverter.createXMLTag(TIMEZONE_TAG, HTMLEncode.encode(user.getTimeZone())));
        }
        if (user.getURL() != null) {
            buf.append(StatusXMLConverter.createXMLTag(URL_TAG, HTMLEncode.encode(user.getURL().toString())));
        }
        buf.append(StatusXMLConverter.createXMLTag(UTCOFFSET_TAG, user.getUtcOffset()));
        buf.append(StatusXMLConverter.createXMLTag(CONTRIBUTORS_ENABLE_TAG, user.isContributorsEnabled()));
        buf.append(StatusXMLConverter.createXMLTag(GEO_ENABLE_TAG, user.isGeoEnabled()));
        buf.append(StatusXMLConverter.createXMLTag(PROFILE_BACKGROUND_TILED_TAG, user.isProfileBackgroundTiled()));
        buf.append(StatusXMLConverter.createXMLTag(PROTECTED_TAG, user.isProtected()));
        buf.append(StatusXMLConverter.createXMLTag(VERIFIED_TAG, user.isVerified()));
        buf.append("</user>\n");
        return buf.toString();
    }

    private static String createXMLTag(String tag, String data) {
        return "<" + tag + ">" + data + "</" + tag + ">\n";
    }

    private static String createXMLTag(String tag, long data) {
        return "<" + tag + ">" + data + "</" + tag + ">\n";
    }

    private static String createXMLTag(String tag, int data) {
        return "<" + tag + ">" + data + "</" + tag + ">\n";
    }

    private static String createXMLTag(String tag, boolean data) {
        return "<" + tag + ">" + data + "</" + tag + ">\n";
    }

    public static List<Status> XMLToStatus(String xmlData) throws SAXParseException {
        if (xmlData == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = null;
            StringReader sr = new StringReader(xmlData);
            InputSource is = new InputSource(sr);
            doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            NodeList comments = root.getElementsByTagName(TWEET_TAG);
            ArrayList<Status> ret = new ArrayList<Status>();
            int i = 0;
            while (i < comments.getLength()) {
                Element element = (Element)comments.item(i);
                String date = StatusXMLConverter.getChildren(element, DATE_TAG);
                String location = StatusXMLConverter.getChildren(element, LOCATION_TAG);
                String id = StatusXMLConverter.getChildren(element, ID_TAG);
                String replyToScreenName = StatusXMLConverter.getChildren(element, REPLY_TO_SCREEN_NAME_TAG);
                String replyStatusID = StatusXMLConverter.getChildren(element, REPLY_STATUS_ID_TAG);
                String replyUserID = StatusXMLConverter.getChildren(element, REPLY_STATUS_ID_TAG);
                String place = StatusXMLConverter.getChildren(element, PLACE_TAG);
                NodeList userNode = element.getElementsByTagName(USER_TAG);
                String retweetStatus = StatusXMLConverter.getChildren(element, RETWEET_STATUS_TAG);
                String text = StatusXMLConverter.getChildren(element, TEXT_TAG);
                String favorite = StatusXMLConverter.getChildren(element, FAVORITE_TAG);
                String retweet = StatusXMLConverter.getChildren(element, RETWEET_TAG);
                String truncated = StatusXMLConverter.getChildren(element, TRUNCATED_TAG);
                String source = StatusXMLConverter.getChildren(element, SOURCE_TAG);
                SimpleStatus status = new SimpleStatus();
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
                try {
                    if (date != null) {
                        status.setCreatedAt(dateFormat.parse(date));
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (id != null) {
                    status.setId(Long.parseLong(id));
                }
                status.setInReplyToScreenName(replyToScreenName);
                if (replyStatusID != null) {
                    status.setInReplyToStatusId(Long.parseLong(replyStatusID));
                }
                if (replyUserID != null) {
                    status.setInReplyToUserId(Integer.parseInt(replyUserID));
                }
                status.setText(text);
                if (favorite != null) {
                    status.setFavorited(Boolean.parseBoolean(favorite));
                }
                if (retweet != null) {
                    status.setRetweet(Boolean.parseBoolean(retweet));
                }
                if (truncated != null) {
                    status.setTruncated(Boolean.parseBoolean(truncated));
                }
                if (userNode != null) {
                    User u = StatusXMLConverter.XMLNodeToUser(userNode);
                    status.setUser(u);
                }
                status.setSource(source);
                ret.add(status);
                ++i;
            }
            return ret;
        }
        catch (SAXParseException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static User XMLNodeToUser(NodeList node) throws SAXParseException {
        SimpleUser ret = null;
        try {
            int i = 0;
            while (i < node.getLength()) {
                Constable v;
                ret = new SimpleUser();
                Element element = (Element)node.item(i);
                String createdAt = StatusXMLConverter.getChildren(element, CREATED_AT_TAG);
                String description = StatusXMLConverter.getChildren(element, DESCRIPTION_TAG);
                String favorites = StatusXMLConverter.getChildren(element, FAVOURITES_TAG);
                String followers = StatusXMLConverter.getChildren(element, FOLLOWERS_TAG);
                String friends = StatusXMLConverter.getChildren(element, FRIENDS_TAG);
                String lang = StatusXMLConverter.getChildren(element, LANG_TAG);
                String name = StatusXMLConverter.getChildren(element, NAME_TAG);
                String profileBackgroundColor = StatusXMLConverter.getChildren(element, PROFILE_BACKGROUND_COLOR_TAG);
                String profileBackgroundImageURL = StatusXMLConverter.getChildren(element, PROFILE_BACKGROUND_IMAGE_URL_TAG);
                String profileImageURL = StatusXMLConverter.getChildren(element, PROFILE_IMAGE_URL);
                String profileLinkColor = StatusXMLConverter.getChildren(element, PROFILE_LINK_COLOR_TAG);
                String profileSidebarBorderColor = StatusXMLConverter.getChildren(element, PROFILE_SIDEBAR_BORDER_COLOR_TAG);
                String profileSidebarFillColor = StatusXMLConverter.getChildren(element, PROFILE_SIDEBAR_FILL_COLOR_TAG);
                String profileTextColor = StatusXMLConverter.getChildren(element, PROFILE_TEXT_COLOR_TAG);
                String screenName = StatusXMLConverter.getChildren(element, SCREEN_NAME);
                String statusesCount = StatusXMLConverter.getChildren(element, STATUSES_COUNT_TAG);
                String timeZone = StatusXMLConverter.getChildren(element, TIMEZONE_TAG);
                String url = StatusXMLConverter.getChildren(element, URL_TAG);
                String utcOffset = StatusXMLConverter.getChildren(element, UTCOFFSET_TAG);
                String contributorEnable = StatusXMLConverter.getChildren(element, CONTRIBUTORS_ENABLE_TAG);
                String geoEnable = StatusXMLConverter.getChildren(element, GEO_ENABLE_TAG);
                String profileBackgroundTiled = StatusXMLConverter.getChildren(element, PROFILE_BACKGROUND_TILED_TAG);
                String protectedTag = StatusXMLConverter.getChildren(element, PROTECTED_TAG);
                String verified = StatusXMLConverter.getChildren(element, VERIFIED_TAG);
                String id = StatusXMLConverter.getChildren(element, ID_TAG);
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
                try {
                    if (createdAt != null) {
                        ret.setStatusCreatedAt(dateFormat.parse(createdAt));
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                ret.setDescription(description);
                if (favorites != null) {
                    v = Integer.valueOf(Integer.parseInt(favorites));
                    ret.setFavouritesCount((Integer)v);
                }
                if (followers != null) {
                    v = Integer.valueOf(Integer.parseInt(followers));
                    ret.setFollowersCount((Integer)v);
                }
                if (friends != null) {
                    v = Integer.valueOf(Integer.parseInt(friends));
                    ret.setFriendsCount((Integer)v);
                }
                ret.setLang(lang);
                ret.setName(name);
                ret.setProfileBackgroundColor(profileBackgroundColor);
                ret.setProfileBackgroundImageUrl(profileBackgroundImageURL);
                if (profileImageURL != null) {
                    ret.setProfileImageURL(new URL(profileImageURL));
                }
                ret.setProfileLinkColor(profileLinkColor);
                ret.setProfileSidebarBorderColor(profileSidebarBorderColor);
                ret.setProfileSidebarFillColor(profileSidebarFillColor);
                ret.setProfileTextColor(profileTextColor);
                ret.setScreenName(screenName);
                if (statusesCount != null) {
                    v = Integer.valueOf(Integer.parseInt(statusesCount));
                    ret.setStatusesCount((Integer)v);
                }
                ret.setTimeZone(timeZone);
                if (url != null) {
                    ret.setURL(new URL(url));
                }
                if (utcOffset != null) {
                    v = Integer.valueOf(Integer.parseInt(utcOffset));
                    ret.setUtcOffset((Integer)v);
                }
                if (contributorEnable != null) {
                    v = Boolean.valueOf(Boolean.parseBoolean(contributorEnable));
                    ret.setContributorsEnabled((Boolean)v);
                }
                if (geoEnable != null) {
                    v = Boolean.valueOf(Boolean.parseBoolean(geoEnable));
                    ret.setGeoEnabled((Boolean)v);
                }
                if (profileBackgroundTiled != null) {
                    v = Boolean.valueOf(Boolean.parseBoolean(profileBackgroundTiled));
                    ret.setProfileBackgroundTiled((Boolean)v);
                }
                if (protectedTag != null) {
                    v = Boolean.valueOf(Boolean.parseBoolean(protectedTag));
                    ret.setProtected((Boolean)v);
                }
                if (verified != null) {
                    v = Boolean.valueOf(Boolean.parseBoolean(verified));
                    ret.setVerified((Boolean)v);
                }
                if (id != null) {
                    v = Integer.valueOf(Integer.parseInt(id));
                    ret.setId(((Integer)v).intValue());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String getChildren(Element element, String tagName) {
        NodeList list = element.getElementsByTagName(tagName);
        Element cElement = (Element)list.item(0);
        if (cElement == null || cElement.getFirstChild() == null) {
            return null;
        }
        return cElement.getFirstChild().getNodeValue();
    }
}

