/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.TwitterException;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.T4JInternalStringUtil;

public class GeoLocation
implements Serializable {
    protected double latitude;
    protected double longitude;
    private static final long serialVersionUID = -4847567157651889935L;

    public GeoLocation(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    static GeoLocation getInstance(JSONObject json) throws TwitterException {
        try {
            if (!json.isNull("geo")) {
                String coordinates = json.getJSONObject("geo").getString("coordinates");
                coordinates = coordinates.substring(1, coordinates.length() - 1);
                String[] point = T4JInternalStringUtil.split(coordinates, ",");
                return new GeoLocation(Double.parseDouble(point[0]), Double.parseDouble(point[1]));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        return null;
    }

    static GeoLocation[][] coordinatesAsGeoLocationArray(JSONArray coordinates) throws TwitterException {
        try {
            GeoLocation[][] boundingBox = new GeoLocation[coordinates.length()][];
            for (int i = 0; i < coordinates.length(); ++i) {
                JSONArray array = coordinates.getJSONArray(i);
                boundingBox[i] = new GeoLocation[array.length()];
                for (int j = 0; j < array.length(); ++j) {
                    JSONArray coordinate = array.getJSONArray(j);
                    boundingBox[i][j] = new GeoLocation(coordinate.getDouble(1), coordinate.getDouble(0));
                }
            }
            return boundingBox;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoLocation)) {
            return false;
        }
        GeoLocation that = (GeoLocation)o;
        if (Double.compare(that.getLatitude(), this.latitude) != 0) {
            return false;
        }
        return Double.compare(that.getLongitude(), this.longitude) == 0;
    }

    public int hashCode() {
        long temp = this.latitude != 0.0 ? Double.doubleToLongBits(this.latitude) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.longitude != 0.0 ? Double.doubleToLongBits(this.longitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoLocation{latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
    }
}

