/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.AccountSettings;
import twitter4j.AccountTotals;
import twitter4j.AsyncTwitter;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.Friendship;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.ProfileImage;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.RelatedResults;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SimilarPlaces;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.Twitter;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.TwitterListener;
import twitter4j.TwitterMethod;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.RequestToken;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.DispatcherFactory;

class AsyncTwitterImpl
extends TwitterBaseImpl
implements AsyncTwitter {
    private static final long serialVersionUID = -2008667933225051907L;
    private final Twitter twitter;
    private final List<TwitterListener> listeners = new ArrayList<TwitterListener>();
    private static transient Dispatcher dispatcher;

    AsyncTwitterImpl(Configuration conf) {
        super(conf);
        this.twitter = new TwitterFactory(conf).getInstance(this.auth);
    }

    AsyncTwitterImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.twitter = new TwitterFactory(conf).getInstance(auth);
    }

    public void addListener(TwitterListener listener) {
        this.listeners.add(listener);
    }

    public void search(final Query query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEARCH, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                QueryResult result = AsyncTwitterImpl.this.twitter.search(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searched(result);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getTrends() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitterImpl.this.twitter.getTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getCurrentTrends() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CURRENT_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitterImpl.this.twitter.getCurrentTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotCurrentTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getCurrentTrends(final boolean excludeHashTags) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CURRENT_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitterImpl.this.twitter.getCurrentTrends(excludeHashTags);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotCurrentTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDailyTrends() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DAILY_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List trendsList = AsyncTwitterImpl.this.twitter.getDailyTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDailyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDailyTrends(final Date date, final boolean excludeHashTags) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DAILY_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List trendsList = AsyncTwitterImpl.this.twitter.getDailyTrends(date, excludeHashTags);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDailyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getWeeklyTrends() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.WEEKLY_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List trendsList = AsyncTwitterImpl.this.twitter.getWeeklyTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotWeeklyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getWeeklyTrends(final Date date, final boolean excludeHashTags) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.WEEKLY_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                List trendsList = AsyncTwitterImpl.this.twitter.getWeeklyTrends(date, excludeHashTags);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotWeeklyTrends(trendsList);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getPublicTimeline() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.PUBLIC_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getPublicTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotPublicTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getHomeTimeline() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.HOME_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getHomeTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotHomeTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getHomeTimeline(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getHomeTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotHomeTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsTimeline() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFriendsTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsTimeline(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFriendsTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(final long userId, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserTimeline(String screenName) {
        this.getUserTimeline(screenName, new Paging());
    }

    public void getUserTimeline(long userId) {
        this.getUserTimeline(userId, new Paging());
    }

    public void getUserTimeline() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getMentions() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MENTIONS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getMentions();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMentions((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getMentions(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MENTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getMentions(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMentions((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByMe() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_BY_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedByMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByMe(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_BY_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedByMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToMe() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_TO_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedToMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToMe(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_TO_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedToMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetsOfMe() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETS_OF_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetsOfMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetsOfMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetsOfMe(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetsOfMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetsOfMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByUser(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_BY_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedByUser(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByUser((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByUser(final long userId, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_BY_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedByUser(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByUser((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToUser(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_TO_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedToUser(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToUser((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedToUser(final long userId, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_TO_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetedToUser(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedToUser((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showStatus(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.showStatus(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final String statusText) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.updateStatus(statusText);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateStatus(final StatusUpdate latestStatus) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.updateStatus(latestStatus);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyStatus(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.destroyStatus(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void retweetStatus(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEET_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.retweetStatus(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.retweetedStatus(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweets(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweets(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweets((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedBy(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_BY, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getRetweetedBy(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedBy((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRetweetedByIDs(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETED_BY_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getRetweetedByIDs(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetedByIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showUser(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUser(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserDetail(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showUser(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUser(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserDetail(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupUsers(final String[] screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.lookupUsers(screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedupUsers((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupUsers(final long[] ids) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.lookupUsers(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedupUsers((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void searchUsers(final String query, final int page) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEARCH_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.searchUsers(query, page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searchedUser((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSuggestedUserCategories() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SUGGESTED_USER_CATEGORIES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList categories = AsyncTwitterImpl.this.twitter.getSuggestedUserCategories();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSuggestedUserCategories((ResponseList<Category>)categories);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_SUGGESTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getUserSuggestions(categorySlug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserSuggestions((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getMemberSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MEMBER_SUGGESTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getMemberSuggestions(categorySlug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMemberSuggestions((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getProfileImage(final String screenName, final ProfileImage.ImageSize size) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ProfileImage profileImage = AsyncTwitterImpl.this.twitter.getProfileImage(screenName, size);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotProfileImage(profileImage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAccountTotals() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ACCOUNT_TOTALS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccountTotals accountTotals = AsyncTwitterImpl.this.twitter.getAccountTotals();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAccountTotals(accountTotals);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAccountSettings() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ACCOUNT_SETTINGS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccountSettings accountSettings = AsyncTwitterImpl.this.twitter.getAccountSettings();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAccountSettings(accountSettings);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFriendsStatuses(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFriendsStatuses(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsStatuses(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFriendsStatuses(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsStatuses((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersStatuses(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFollowersStatuses(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersStatuses((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersStatuses(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFollowersStatuses(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersStatuses((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersStatuses(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFollowersStatuses(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersStatuses((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createUserList(final String listName, final boolean isPublicList, final String description) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserList(listName, isPublicList, description);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateUserList(final int listId, final String newListName, final boolean isPublicList, final String newDescription) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.updateUserList(listId, newListName, isPublicList, newDescription);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserLists(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserLists(listOwnerScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserLists((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showUserList(final String listOwnerScreenName, final int id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.showUserList(listOwnerScreenName, id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyUserList(final int listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserList(listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListStatuses(final String listOwnerScreenName, final int id, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserListStatuses(listOwnerScreenName, id, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListStatuses((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListStatuses(final long listOwnerId, final int id, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserListStatuses(listOwnerId, id, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListStatuses((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListMemberships(final String listMemberScreenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_MEMBERSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserListMemberships(listMemberScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMemberships((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListSubscriptions(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_SUBSCRIPTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserListSubscriptions(listOwnerScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscriptions((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAllSubscribingUserLists(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ALL_USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList lists = AsyncTwitterImpl.this.twitter.getAllUserLists(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAllUserLists((ResponseList<UserList>)lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAllSubscribingUserLists(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ALL_USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList lists = AsyncTwitterImpl.this.twitter.getAllUserLists(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAllUserLists((ResponseList<UserList>)lists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListMembers(final String listOwnerScreenName, final int listId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListMembers(listOwnerScreenName, listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMembers((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListMembers(final long listOwnerId, final int listId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListMembers(listOwnerId, listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMembers((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void addUserListMember(final int listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ADD_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.addUserListMember(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.addedUserListMember(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void addUserListMembers(final int listId, final long[] userIds) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ADD_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.addUserListMembers(listId, userIds);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.addedUserListMembers(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void addUserListMembers(final int listId, final String[] screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ADD_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.addUserListMembers(listId, screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.addedUserListMembers(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void deleteUserListMember(final int listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DELETE_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.deleteUserListMember(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.deletedUserListMember(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void checkUserListMembership(final String listOwnerScreenName, final int listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CHECK_LIST_MEMBERSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.checkUserListMembership(listOwnerScreenName, listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListMembership(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getUserListSubscribers(final String listOwnerScreenName, final int listId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_SUBSCRIBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListSubscribers(listOwnerScreenName, listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscribers((PagableResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void subscribeUserList(final String listOwnerScreenName, final int listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.subscribeUserList(listOwnerScreenName, listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.subscribedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void unsubscribeUserList(final String listOwnerScreenName, final int listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UNSUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.unsubscribeUserList(listOwnerScreenName, listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.unsubscribedUserList(list);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void checkUserListSubscription(final String listOwnerScreenName, final int listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CHECK_LIST_SUBSCRIPTION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.checkUserListSubscription(listOwnerScreenName, listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListSubscription(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDirectMessages() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DIRECT_MESSAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getDirectMessages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getDirectMessages(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSentDirectMessages() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getSentDirectMessages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSentDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSentDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getSentDirectMessages(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSentDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void sendDirectMessage(final String screenName, final String text) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.sendDirectMessage(screenName, text);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.sentDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void sendDirectMessage(final long userId, final String text) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.sendDirectMessage(userId, text);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.sentDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyDirectMessage(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.destroyDirectMessage(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showDirectMessage(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.showDirectMessage(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessage(directMessage);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final String screenName, final boolean follow) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(screenName, follow);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFriendship(final long userId, final boolean follow) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(userId, follow);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyFriendship(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyFriendship(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyFriendship(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyFriendship(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFriendship(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void existsFriendship(final String userA, final String userB) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.EXISTS_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                for (TwitterListener listener : listeners) {
                    boolean exists = AsyncTwitterImpl.this.twitter.existsFriendship(userA, userB);
                    try {
                        listener.gotExistsFriendship(exists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showFriendship(final String sourceScreenName, final String targetScreenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.showFriendship(sourceScreenName, targetScreenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void showFriendship(final long sourceId, final long targetId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.showFriendship(sourceId, targetId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getIncomingFriendships(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.INCOMING_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getIncomingFriendships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotIncomingFriendships(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getOutgoingFriendships(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OUTGOING_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getOutgoingFriendships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOutgoingFriendships(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupFriendships(final String[] screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList friendships = AsyncTwitterImpl.this.twitter.lookupFriendships(screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedUpFriendships((ResponseList<Friendship>)friendships);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void lookupFriendships(final long[] ids) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList friendships = AsyncTwitterImpl.this.twitter.lookupFriendships(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedUpFriendships((ResponseList<Friendship>)friendships);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateFriendship(final String screenName, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.updateFriendship(screenName, enableDeviceNotification, retweet);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateFriendship(final long userId, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.updateFriendship(userId, enableDeviceNotification, retweet);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedFriendship(relationship);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFriendsIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFriendsIDs(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFriendsIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFriendsIDs(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFollowersIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFollowersIDs(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFollowersIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFollowersIDs(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void verifyCredentials() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.VERIFY_CREDENTIALS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.verifyCredentials();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.verifiedCredentials(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfile(final String name, final String url, final String location, final String description) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfile(name, url, location, description);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfile(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRateLimitStatus() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RATE_LIMIT_STATUS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                RateLimitStatus rateLimitStatus = AsyncTwitterImpl.this.twitter.getRateLimitStatus();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRateLimitStatus(rateLimitStatus);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileColors(final String profileBackgroundColor, final String profileTextColor, final String profileLinkColor, final String profileSidebarFillColor, final String profileSidebarBorderColor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_COLORS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileColors(profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileColors(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileImage(final File image) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileImage(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileImage(final InputStream image) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileImage(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileBackgroundImage(final File image, final boolean tile) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileBackgroundImage(image, tile);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBackgroundImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void updateProfileBackgroundImage(final InputStream image, final boolean tile) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileBackgroundImage(image, tile);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBackgroundImage(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites(final int page) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites(final String id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getFavorites(final String id, final int page) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(id, page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createFavorite(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FAVORITE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.createFavorite(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFavorite(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyFavorite(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_FAVORITE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.destroyFavorite(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFavorite(status);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void enableNotification(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.enableNotification(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.enabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void enableNotification(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.enableNotification(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.enabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void disableNotification(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.disableNotification(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.disabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void disableNotification(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.disableNotification(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.disabledNotification(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createBlock(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createBlock(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyBlock(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void destroyBlock(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedBlock(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void existsBlock(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                boolean exists = AsyncTwitterImpl.this.twitter.existsBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotExistsBlock(exists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void existsBlock(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                boolean exists = AsyncTwitterImpl.this.twitter.existsBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotExistsBlock(exists);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getBlockingUsers() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCKING_USERS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getBlockingUsers();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockingUsers((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getBlockingUsers(final int page) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCKING_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getBlockingUsers(page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockingUsers((ResponseList<User>)users);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getBlockingUsersIDs() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCKING_USERS_IDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getBlockingUsersIDs();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockingUsersIDs(ids);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void reportSpam(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REPORT_SPAM, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.reportSpam(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.reportedSpam(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void reportSpam(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REPORT_SPAM, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.reportSpam(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.reportedSpam(user);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAvailableTrends() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList locations = AsyncTwitterImpl.this.twitter.getAvailableTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAvailableTrends((ResponseList<Location>)locations);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getAvailableTrends(final GeoLocation location) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList locations = AsyncTwitterImpl.this.twitter.getAvailableTrends(location);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAvailableTrends((ResponseList<Location>)locations);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getLocationTrends(final int woeid) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOCATION_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitterImpl.this.twitter.getLocationTrends(woeid);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotLocationTrends(trends);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void searchPlaces(final GeoQuery query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEARCH_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList places = AsyncTwitterImpl.this.twitter.searchPlaces(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searchedPlaces((ResponseList<Place>)places);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getSimilarPlaces(final GeoLocation location, final String name, final String containedWithin, final String streetAddress) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SIMILAR_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                SimilarPlaces similarPlaces = AsyncTwitterImpl.this.twitter.getSimilarPlaces(location, name, containedWithin, streetAddress);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSimilarPlaces(similarPlaces);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void reverseGeoCode(final GeoQuery query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REVERSE_GEO_CODE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList places = AsyncTwitterImpl.this.twitter.reverseGeoCode(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotReverseGeoCode((ResponseList<Place>)places);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getGeoDetails(final String id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.GEO_DETAILS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Place place = AsyncTwitterImpl.this.twitter.getGeoDetails(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotGeoDetails(place);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void createPlace(final String name, final String containedWithin, final String token, final GeoLocation location, final String streetAddress) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_PLACE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Place place = AsyncTwitterImpl.this.twitter.createPlace(name, containedWithin, token, location, streetAddress);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdPlace(place);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getTermsOfService() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.TERMS_OF_SERVICE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                String tos = AsyncTwitterImpl.this.twitter.getTermsOfService();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotTermsOfService(tos);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getPrivacyPolicy() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.PRIVACY_POLICY, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                String privacyPolicy = AsyncTwitterImpl.this.twitter.getPrivacyPolicy();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotPrivacyPolicy(privacyPolicy);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void getRelatedResults(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RELATED_RESULTS, this.listeners){

            @Override
            void invoke(List<TwitterListener> listeners) throws TwitterException {
                RelatedResults relatedResults = AsyncTwitterImpl.this.twitter.getRelatedResults(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRelatedResults(relatedResults);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    public void test() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.TEST, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                boolean ok = AsyncTwitterImpl.this.twitter.test();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.tested(ok);
                    }
                    catch (Exception ignore) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        super.shutdown();
        Class clazz = AsyncTwitterImpl.class;
        synchronized (clazz) {
            if (dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
        }
        this.twitter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dispatcher getDispatcher() {
        if (null == dispatcher) {
            Class clazz = AsyncTwitterImpl.class;
            synchronized (clazz) {
                if (null == dispatcher) {
                    dispatcher = new DispatcherFactory(this.conf).getInstance();
                }
            }
        }
        return dispatcher;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.twitter.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.twitter.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.twitter.getOAuthRequestToken(callbackUrl);
    }

    public AccessToken getOAuthAccessToken() throws TwitterException {
        return this.twitter.getOAuthAccessToken();
    }

    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(oauthVerifier);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.twitter.setOAuthAccessToken(accessToken);
    }

    public AccessToken getOAuthAccessToken(String screenName, String password) throws TwitterException {
        return this.twitter.getOAuthAccessToken(screenName, password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AsyncTwitterImpl that = (AsyncTwitterImpl)o;
        if (this.listeners != null ? !((Object)this.listeners).equals(that.listeners) : that.listeners != null) {
            return false;
        }
        return !(this.twitter != null ? !this.twitter.equals(that.twitter) : that.twitter != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.twitter != null ? this.twitter.hashCode() : 0);
        result = 31 * result + (this.listeners != null ? ((Object)this.listeners).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AsyncTwitterImpl{twitter=" + this.twitter + ", listeners=" + this.listeners + '}';
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AsyncTask
    implements Runnable {
        List<TwitterListener> listeners;
        TwitterMethod method;

        AsyncTask(TwitterMethod method, List<TwitterListener> listeners) {
            this.method = method;
            this.listeners = listeners;
        }

        abstract void invoke(List<TwitterListener> var1) throws TwitterException;

        @Override
        public void run() {
            block5: {
                try {
                    this.invoke(this.listeners);
                }
                catch (TwitterException te) {
                    if (null == this.listeners) break block5;
                    for (TwitterListener listener : this.listeners) {
                        try {
                            listener.onException(te, this.method);
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
        }
    }
}

