<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	require("__define_csv-import.php");
	my_session_start();
	ini_set("memory_limit", MEMORY_LIMIT_INI_SET);			//メモリサイズ
	ini_set("max_execution_time", MAX_EXECUTION_TIME_INI_SET);	//最大実行時間
	if ($_POST['import']) {
		myfile_file_put_contents(CSV_IMPORT_FOLDER.CSV_UPLOAD_FILE_NAME, $_SESSION['spreadsheet_csv_filename'], LOCK_EX);
		myfile_unlink(CSV_IMPORT_FOLDER.CSV_FILE_NAME);
		myfile_rename(CSV_IMPORT_FOLDER.CSV_FILE_NAME_TMP, CSV_IMPORT_FOLDER.CSV_FILE_NAME);
		redirect('index.php');
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<title>CSV to スプレッドシート風表示：CSVインポート</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/db_tools.css?20131020">
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">CSV to スプレッドシート風表示：CSVインポート</span>
<a href="index.php" style="margin-left:20px;">戻る</a>
</p>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" enctype="multipart/form-data" style="margin-top:5px;">
<p style="color: #9d974b">
※ デリミッタ(区切り文字)はカンマ(&nbsp;,&nbsp;)、文字列の囲みはダブルクォーテーション(")のみサポート。<br>
※ 文字コードは、Shift-JIS、UTF-8、EUCなど自動判別します。
</p>
<table>
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" name="filename" size=40 style="button-font-size:small">
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
	</td>
</tr>
</table>
</form>
<?php
if ($_POST) {
	if (($csv_file = post_check('filename')) == True) {
		if (!($csv_file_name = csv_upload($csv_file))) {
			error_exit('csvファイルにデータがありません。');
		}
?>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<div style="margin: 10px 0 0 50px;">
<input type="submit" name="import" value="このデータをインポートする">
</div>
</form>
<?php
	}
}
?>
<br>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function csv_upload($csv_file) {
	if ($csv_file == CSV_FILE_UPLOAD) {

		$_SESSION['spreadsheet_csv_filename'] = $_FILES['filename']['name'];


		$attachFile = file_upload_to_name("filename", CSV_IMPORT_FOLDER, CSV_FILE_NAME_TMP);
		$readFile = CSV_IMPORT_FOLDER.$attachFile;
	} else {
		$readFile = CSV_IMPORT_FOLDER.CSV_FILE_NAME_TMP;
	}
	if (list_table($readFile)) {
		return $readFile;
	} else {
		return false;
	}
}
function list_table($readFile) {
	$numRows = 0;
	if (!($contents = file_get_contents($readFile))) return false;
	file_put_contents($readFile, mb_convert_kana(mb_convert_encoding($contents, 'UTF-8', MB_CONVERT_ENCODING_AUTO),'a'));
		// UTF-8に変換： fgetcsvはShift-JISでは正常処理できない
		// 全角英数字を半角英数字に変換する： fgetcsvは全角英数字を正常処理できない
	$handle = fopen($readFile, 'r');
	while (($data = fgetcsv($handle)) !== FALSE) {
		$numCols = count($data);
		$numRows++;
	}
	fclose($handle);
	if ($numRows < 2 || $numCols < 1) return False;
	if ($numRows > 6) {
		$viewRows = 6;
	} else {
		$viewRows = $numRows;
	}
?>
<p>レコード件数：<span class="mp_rowcnt"><?= $numRows-1 ?></span>件
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color: #808080">(先頭の<?= $viewRows-1 ?>件表示)</span></p>
<table class="excel_table" cellspacing=1>
	<thead>
		<tr>
<?php
	$handle = fopen($readFile, 'r');
	if (($data = fgetcsv($handle)) !== FALSE) {
		for ($col = 0; $col < $numCols; $col++) {
?>
			<th><?= my_htmlspecialchars(str_replace("\\\\","\\",$data[$col])) ?></th>
<?php
		}
?>
		</tr>
	</thead>
	<tbody>
<?php
	}
	$row = 1;
	while (($data = fgetcsv($handle)) !== FALSE && $row < $viewRows) {
?>
		<tr>
<?php
		for ($col = 0; $col < $numCols; $col++) {
?>
			<td><?= my_htmlspecialchars(str_replace("\\\\","\\",$data[$col])) ?></td>
<?php
		}
?>
		</tr>
<?php
		$row++;
	}
	fclose($handle);
?>
	</tbody>
</table>
<?php
	return True;
}
function post_check($filename) {
	if ($_POST['upload']) {
		if (strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.csv' or strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.txt') {
			return CSV_FILE_UPLOAD;
		} else {
			error_exit('拡張子が.CSVではありません。');
			return false;
		}
	} elseif ($_POST['import']) {
		if (file_exists(CSV_IMPORT_FOLDER.CSV_FILE_NAME_TMP)) {
			return CSV_FILE_EXIST;
		} else {
			return false;
		}
	}
}
?>
