<?php
function rss_view_frame($rec, $table_width=194, $article_cnt=100, $pop_width=0) {
	if ($rec['c_rss_url'].'' == '') return;
?>
	<div class="rss_thumbnail" id="<?= $rec['id_rss'] ?>">
	<table class="rss_article" style="width: <?= $table_width ?>px; border-color: <?= $rec['c_displayColor'] ?>; background-color: <?= $rec['c_displayColor'] ?>;">
	<tr><th class="rss_article_title">
		<a href="<?= $rec['c_home_url'] ?>" target="_blank"><?= $rec['c_title'] ?></a>
		<?php if ($pop_width <> 0) { ?>
		&nbsp;<a href='javascript:popup_rss("<?= $rec['id_rss'] ?>", <?= $pop_width+36 ?>)' class='popup_rss_link'>↑</a>
		<a href='javascript:popup_feed("<?= $rec['id_rss'] ?>")' class='popup_rss_link'>↑</a>
		<?php } ?>
	</th></tr>
	<tr><td id="rss_<?= $rec['id_rss'] ?>" class="rss_article_body" style="border-color: <?= $rec['c_displayColor'] ?>;"><br><br><br><br><br><br></td></tr>
	</table>
	</div>
<?php
}
function rss_view($rec, $table_width=194, $pop_width=0, $article_cnt=0) {
	if ($rec['c_rss_url'].'' == '') return;
	if (SIMPLEXML_LOAD_CURL_USE == 'YES') {
		$result = curl_get_contents($rec['c_rss_url']);
		$rss = simplexml_load_string($result);
	} else {
		$rss = my_simplexml_load_file($rec['c_rss_url']);
	}
	if ($rss) {
		if ($article_cnt == 0) {
			$article_cnt = $rec['c_article_cnt'];
		}
?>
	<ul class="rss_article_item">
	<?
		if ($rss->item) {				// RSS1.0
			rss_get_1_0($rss, $article_cnt);
		} else if ($rss->channel) {			// RSS2.0
			rss_get_2_0($rss, $article_cnt);
		} else if ($rss->entry) {			// ATOM
			rss_atom($rss, $article_cnt);
		} else {
			echo '<span class="error_msg">RSS解析エラー</span>';
			//print_r($rss);
		}
	?>
	</ul>
<?php	} else { ?>
		<span class='error_msg'>RSS取得エラー</span>
<?php
	}
}
function rss_view_pop($rec, $table_width=194, $article_cnt=100, $pop_width=0) {
	if ($rec['c_rss_url'].'' == '') return;
?>
	<table class="rss_article" style="width: <?= $table_width ?>px; border-color: <?= $rec['c_displayColor'] ?>; background-color: <?= $rec['c_displayColor'] ?>;">
	<tr><th class="rss_article_title">
		<a href="<?= $rec['c_home_url'] ?>" target="_blank"><?= $rec['c_title'] ?></a>
		<?php if ($pop_width <> 0) { ?>
		&nbsp;<a href='javascript:popup_rss("<?= $rec['id_rss'] ?>", <?= $pop_width+36 ?>)' class='popup_rss_link'>↑</a>
		<a href='javascript:popup_feed("<?= $rec['id_rss'] ?>")' class='popup_rss_link'>↑</a>
		<?php } ?>
	</th></tr>
	<tr><td class="rss_article_body" style="border-color: <?= $rec['c_displayColor'] ?>;">
<?php
	rss_view($rec, $table_width, $pop_width, $article_cnt);
?>
	</td></tr>
	</table>
<?php
}
function rss_get_1_0($rss, $article_cnt) {
	$cnt = 0;
	foreach ($rss->item as $item) {
		$link = $item->link;
		$title = $item->title;
		$description = $item->description;
		$rssDate = $item->children('http://purl.org/dc/elements/1.1/')->date;
		$pubDate = date('y/m/d H:i:s', strtotime($rssDate));
		if ($link <> '') {
?>
		<li><a href="<?= $link ?>" target="_blank"><?= $title ?></a>
		<span class="rss_article_time">(<?= $pubDate ?>)</span>
		</li>
<?php
			if (++$cnt >= $article_cnt) break;
		}
	}
}
function rss_get_2_0($rss, $article_cnt) {
	$cnt = 0;
	foreach ($rss->channel->item as $item) {
		$link = $item->link;
		$title = $item->title;
		$description = $item->description;
		$rssDate = $item->pubDate;
		$pubDate = date('y/m/d H:i:s', strtotime($rssDate));
		if ($link <> '') {
?>
		<li><a href="<?= $link?>" target="_blank"><?= $title ?></a>
		<span class="rss_article_time">(<?= $pubDate ?>)</span>
		</li>
<?php
			if (++$cnt >= $article_cnt) break;
		}
	}
}
function rss_atom($rss, $article_cnt) {
	$cnt = 0;
	foreach ($rss->entry as $item) {
		$link = $item->link->attributes()->href;
		$title = $item->title;
		$description = $item->content;
		$rssDate = $item->published;
		$pubDate = date('y/m/d H:i:s', strtotime($rssDate));
		if ($link <> '') {
?>
		<li><a href="<?= $link ?>" target="_blank"><?= $title ?></a>
		<span class="rss_article_time">(<?= $pubDate ?>)</span>
		</li>
<?php
			if (++$cnt >= $article_cnt) break;
		}
	}
}
?>
