#!/bin/sh
#
# createapp.sh - Create an application bundle from entry file
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

MIKUVERSION=@VERSION@

set -e
PATH=/usr/bin:/bin:/usr/sbin:/sbin   # /sbin is needed for md5

if [ -z "$MIKUBUNDLE" ]; then
  dir=`dirname "$0"`
  MIKUBUNDLE=`cd "$dir/../../.." && pwd`
fi
MIKURESOURCE="$MIKUBUNDLE/Contents/Resources"

if [ -z "$WINEPREFIX" ] || [ ! -d "$WINEPREFIX" ]; then
  echo "$0: WINEPREFIX does not exist." 1>&2
  exit 1
fi

dstdir=Programs
if expr "x$1" : 'x-d' > /dev/null; then
  dstdir=`expr "x$1" : 'x-d\(.*\)'`
  shift
fi
entry="$1"
if [ -z "$entry" ]; then
  echo "usage: $0 [ -d<dstdir> ] <_EntryXXX>" 1>&2
fi

tmp=`mktemp -d -t tmp`
trap "rm -rf $tmp" EXIT

name=`sed -n '/^NAME /{;s/^[A-Z0-9:]* //;p;}' "$entry"`
folder=`sed -n '/^FOLDER /{;s/^[A-Z0-9:]* //;p;}' "$entry"`
exefile=`sed -n '/^FILE /{;s/^[A-Z0-9:]* //;p;}' "$entry"`
bundlesubid=`md5 -q -s "$WINEPREFIX	$exefile"`

tmpldir="$MIKURESOURCE/NegiHelper.apptemplate"

awk -v "ENTRYFILE=$entry" \
    -v "MIKUVERSION=$MIKUVERSION" \
    -v "BUNDLESUBID=$bundlesubid" \
    -f "$MIKURESOURCE/script/infoplist.awk" \
    "$tmpldir/Contents/Info.plist" \
  > "$tmp/Info.plist"

bundle_id () {
  awk '/<key>CFBundleIdentifier<\/key>/{getline;gsub("[ \t]*</?string>","",$0);print}' "$1"
}

bundleid=`bundle_id "$tmp/Info.plist"`

n=0
appdir="$dstdir$folder/$name.app"
while :; do
  bid=`bundleid "$appdir/Contents/Info.plist"` || break
  [ "x$bid" = "x$bundleid" ] && break
  n=`expr $n + 1`
  appdir="$dstdir$folder/$name $n.app"
done

# use ln instead of cp as many as possible in order to reduce the capacity.
tmpldir="$MIKURESOURCE/NegiHelper.apptemplate"
mkdir -p "$appdir" || :
echo "$PWD"
(cd "$tmpldir" && find * -type d) \
  | (while read i; do mkdir -p "$appdir/$i" 2>/dev/null || :; done); \
(cd "$tmpldir" && find * -type f) \
  | (while read i; do \
       rm -f "$appdir/$i"; \
       ln "$tmpldir/$i" "$appdir/$i" \
       || cp -p "$tmpldir/$i" "$appdir/$i" \
       || exit $?; \
     done)

entrydir=`dirname "$entry"`
for i in `sed -n '/^[A-Z0-9:]*ICON /{;s/^[A-Z0-9:]* //;p;}' "$entry"`; do
  # tiff2icns doesn't accept Japanese filename.
  # So we put .icns file to the temporally directory at first,
  # and then move the .icns file into application bundle.
  tiff2icns "$entrydir/$i" "$tmp/tmp.icns"
  icns=`basename "$i" .tiff`.icns
  rm -f "$appdir/Contents/Resources/$icns"
  mv "$tmp/tmp.icns" "$appdir/Contents/Resources/$icns"
done

rm -f "$appdir/Contents/Info.plist"
mv "$tmp/Info.plist" "$appdir/Contents/Info.plist"

escape () {
  sed 's/&/&amp;/g;s/</&lt;/g;s/>/&gt;/g' <<END
$1
END
}

# FIXME: Workaround for Tiger:
# activate event succeeds but doesn't return.
# Need to set a time limit to force to terminate the activation.

rm -f "$appdir/Contents/Resources/environment.plist"
cat > "$appdir/Contents/Resources/environment.plist" <<END
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
	<key>\$LAUNCH_SH</key>
	<string>set -x;exec "\$MIKUBUNDLE/Contents/MacOS/wine" --miku=shellexec -c "\$MIKUEXEFILE"</string>
	<key>\$OPEN_SH</key>
	<string>set -x;exec "\$MIKUBUNDLE/Contents/MacOS/wine" --miku=shellexec "\$@"</string>
	<key>\$ACTIVE_APPLESCRIPT</key>
	<string>with timeout 3 seconds
  tell application "X11" to activate
end timeout
	</string>
	<key>WINEPREFIX</key>
	<string>`escape "$WINEPREFIX"`</string>
	<key>MIKUEXEFILE</key>
	<string>`escape "$exefile"`</string>
</dict>
</plist>
END
