/* -*- objc -*-
 *
 * ProcessManager.h
 *
 * Copyright (C) 2008 MikuInstaller Project. All rights reserved.
 * http://mikuinstaller.sourceforge.jp/
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <Cocoa/Cocoa.h>

@class ProcessWindowController;
@class ProcessManager;
@class ProcessDateStringGenerator;

@interface Process : NSObject {
	ProcessManager *processManager;
	NSMutableData *buffer;
	NSDictionary *properties;
	BOOL noCrashAlert;
}
- (NSDictionary *)properties;
- (void)terminateProcessBy:(NSString *)sender quiet:(BOOL)quiet;
- (NSTask *)task;
- (id)objectForKey:(NSString *)key;
@end

@interface ProcessManager : NSObject {
	ProcessWindowController *processWindow;
	NSMutableArray *currentProcesses;
	NSMutableArray *logMessages;
	ProcessDateStringGenerator *dateGenerator;
}
- (NSArray *)currentProcesses;
- (NSArray *)logMessages;
- (NSWindowController *)processWindow;
- (IBAction)showStatusWindow:(id)sender;
- (Process *)startProcess:(NSString *)command
		arguments:(NSArray *)args
	      environment:(NSDictionary *)env;
- (void)terminateAll;
- (void)log:(NSString *)format, ...;
- (BOOL)saveReportToPath:(NSString *)filename error:(NSError **)error;
@end

NSString * const ProcessCommandLineKey;
NSString * const ProcessIdnetifierKey;
NSString * const ProcessDateKey;
NSString * const LogMessageDateKey;
NSString * const LogMessageProcessIdentifierKey;
NSString * const LogMessageContentKey;

NSString * const ProcessDidTerminateNotification;
NSString * const ProcessDidCloseOutputNotification;
NSString * const ProcessManagerDidChangeProcessesNotification;
