/* -*- objc -*-
 *
 * AutoScrollView.m
 *
 * Copyright (C) 2008 MikuInstaller Project. All rights reserved.
 * http://mikuinstaller.sourceforge.jp/
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "AutoScrollView.h"

@implementation AutoScrollView

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}

- (void)checkAutoScroll
{
	NSRect frame = [[self documentView] frame];
	NSRect bounds = [[self contentView] bounds];
	autoScrollEnabled = (NSMaxY(bounds) >= NSMaxY(frame));
}

- (void)awakeFromNib
{
	[[self documentView] setPostsFrameChangedNotifications:YES];
	[[self contentView] setPostsBoundsChangedNotifications:YES];

	[[NSNotificationCenter defaultCenter]
	 addObserver:self
	 selector:@selector(documentFrameChanged:)
	 name:NSViewFrameDidChangeNotification
	 object:[self documentView]];

	[[NSNotificationCenter defaultCenter]
	 addObserver:self
	 selector:@selector(contentBoundsChanged:)
	 name:NSViewBoundsDidChangeNotification
	 object:[self contentView]];

	[self checkAutoScroll];
}

- (void)contentBoundsChanged:(NSNotification *)notification
{
	[self checkAutoScroll];
}

- (void)documentFrameChanged:(NSNotification *)notification
{
	if (!autoScrollEnabled)
		return;

	NSView *view = [self documentView];
	NSRect frame = [view frame];
	NSRect bounds = [[self contentView] bounds];
	NSPoint origin = NSMakePoint(NSMinX(bounds),
				     NSMaxY(frame) - NSHeight(bounds));
	[view scrollPoint:origin];
}

@end
