/*
 * ApplicationInfo.m
 *
 * Copyright (C) 2008 MikuInstaller Project. All rights reserved.
 * http://mikuinstaller.sourceforge.jp/
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ApplicationInfo.h"

NSString * const ApplicationName = @"MikuInstaller";
NSString * const ApplicationBundleIdentifier =
	@"jp.sourceforge.mikuinstaller.MikuInstaller";

@implementation ApplicationInfo

+ (NSBundle *)applicationBundle
{
	NSString *path;

	path = [[NSWorkspace sharedWorkspace]
		absolutePathForAppBundleWithIdentifier:
		ApplicationBundleIdentifier];
	if (path)
		return [NSBundle bundleWithPath:path];
	else
		return nil;
}

+ (NSString *)pathForApplicationSupport:(NSString *)name
{
	NSArray *appSupportPath;
	NSString *filename;

	appSupportPath = NSSearchPathForDirectoriesInDomains(
		NSApplicationSupportDirectory,
		NSUserDomainMask,
		YES);
	filename = [appSupportPath objectAtIndex:0];
	filename = [filename stringByAppendingPathComponent:ApplicationName];
	if (name)
		filename = [filename stringByAppendingPathComponent:name];

	return filename;
}

+ (NSBundle *)wineBundle
{
	NSString *filename;
	NSBundle *bundle;

	/*
	 * Search Wine.bundle in the following order:
	 * (1) ~/Library/Application Support/MikuInstaller
	 * (2) Resources of MikuInstaller.app
	 */
	filename = [self pathForApplicationSupport:@"Wine.bundle"];
	if (filename) {
		bundle = [NSBundle bundleWithPath:filename];
		if (bundle)
			return bundle;
	}

	bundle = [self applicationBundle];
	if (bundle) {
		filename = [bundle pathForResource:@"Wine" ofType:@"bundle"];
		if (filename) {
			bundle = [NSBundle bundleWithPath:filename];
			if (bundle)
				return bundle;
		}
	}

	return nil;
}

@end
