#!/bin/sh
#
# backend of MikuInstaller
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
# These environment variables must be set:
#   MIKUBUNDLE
#   WINEPREFIX
#   MIKUROOT          -- $HOME/Library/Application Support/MikuInstaller
#   MIKUAPPDIR        -- $HOME/Applications/MikuInstaller
#

WINE="$MIKUBUNDLE/Contents/MacOS/wine"
cmd="$1"
shift

echo "MIKUBUNDLE: $MIKUBUNDLE"
echo "WINEPREFIX: $WINEPREFIX"
echo "MIKUROOT: $MIKUROOT"
echo "MIKUAPPDIR: $MIKUAPPDIR"
echo "command: $cmd"

#sleep 2
#exit

set -x
case "$cmd" in

  install)
    WINEBUNDLE="$1"
    test -n "$WINEBUNDLE" || return 1
    test -d "$WINEBUNDLE" || return 1
    mkdir "$MIKUBUNDLE"
    (cd "$WINEBUNDLE" && pax -rw -v -H -pap Contents "$MIKUBUNDLE") \
     || return $?
    mkdir "$MIKUROOT/prefix" || :
    ;;

  open)
    "$WINE" --miku=debug --miku=shellexec -c "$@"
    ;;

  winecfg)
    "$WINE" --miku=debug --miku=winecmd winecfg
    ;;

  addapp)
    set -e
    old=`find "$MIKUAPPDIR" -name "*.app" -prune -print 2>/dev/null || :`
    "$WINE" --miku=debug --miku=addapp -d"$MIKUAPPDIR"
    new=`find "$MIKUAPPDIR" -name "*.app" -prune -print 2>/dev/null || :`
    set +x
    [ "x$old" = "x$new" ] || open -a Finder "$MIKUAPPDIR"
    ;;

  prefixcreate)
    mkdir -p "$WINEPREFIX" || :
    "$WINE" --miku=debug --miku=prefixcreate
    ;;

  prefixupdate)
    for i in "$MIKUROOT/prefix"/*; do
      [ -d "$i" ] || continue
      WINEPREFIX="$i" "$WINE" --miku=debug --miku=prefixcreate
      WINEPREFIX="$i" "$WINE" --miku=debug --miku=addapp -d"$MIKUAPPDIR"
    done
    ;;

  prefixremove)
    rm -r "$WINEPREFIX"
    ;;

  uninstall)
    rm -r "$MIKUBUNDLE"
    ;;

  *)
    exit 128
    ;;
esac
