package kandata.launcher;

import java.io.*;
import java.util.ArrayList;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;


/**
 * TCg̃Xg{bNX.
 * ToolTipsꏊɂĕς߁AJListpēƎ̃NXB
 */
class SiteListBox extends JList {

	private SiteCategory category;
	static SiteRenderer siteRenderer = new SiteRenderer();
	KandataLauncher launcher;
	private SiteListModel model;

	SiteListBox(KandataLauncher launcher, SiteCategory category) {
		this.launcher = launcher;
		this.category = category;

		model = new SiteListModel(category);
		this.setModel(model);
		this.setCellRenderer(siteRenderer);
		this.addMouseListener(new SiteListMouseListener(launcher));
		this.setToolTipText("Ղ");	// ݒ肵ȂƁAgetToolTipText()Ă΂ȂB
		this.setFixedCellHeight(40);	// 40dot
	}

	/** }EX̂ʒuc[`bvɕ\镶Ԃ. */
	public String getToolTipText(MouseEvent event) {
		// }EX̂ꏊ𒲂ׂB
		int index = locationToIndex(event.getPoint());
		//System.out.println(index);
		if (index == -1) return null;
		Rectangle rect = getCellBounds(index, index);
		if ( ! rect.contains(event.getPoint()) ) return null;
		// TCg̏Ă
		Site site = category.getSiteInfo(index);
		return "<html>"+site.getName()+"<br>"+
			"<b>description</b>="+site.getDesc()+"<br>"+
			"<b>url</b>="+site.getUrl()+"<br>"+
			"<b>client type</b>="+site.getClientType()+"<br>"+
			"<b>version</b>="+site.getVersion()+"<br>";
	}

	/** fA_v^Ƀf[^̓eςƂʒmB*/
	void fireChanged() {
		model.fireChanged();
	}
}
