package kandata.launcher;

import java.io.*;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.awt.*;
import java.awt.event.*;
import java.awt.dnd.*;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;

public class KandataLauncher extends JFrame {

	// model
	ArrayList siteCategories = null;	// ArrayList<SiteCategory>

	// view
	JTabbedPane tab;
	ArrayList lists;		// ArrayList<SiteListBox>

	/** `𐶐B*/
	KandataLauncher() {
		super("KandataLauncher");

		// ȑOۑꂽǂݍ
		siteCategories = loadEnv();
		if (siteCategories == null) {
			// ftHg̃fB
			siteCategories = createDefaultSiteCategories();
		}

		// ANVB
		//NewSiteAction      newSiteAction      = new NewSiteAction(this);
		ExitAction         exitAction         = new ExitAction(this);
		SitePropertyAction sitePropertyAction = new SitePropertyAction(this);
		LaunchAction       launchAction       = new LaunchAction(this);
		DeleteSiteAction   deleteSiteAction   = new DeleteSiteAction(this);
		AboutAction        aboutAction        = new AboutAction(this);
		ActionMap actionmap = new ActionMap();
		actionmap.put("exit",          exitAction);
		actionmap.put("site-property", sitePropertyAction);
		//actionmap.put("new-site",      newSiteAction);
		actionmap.put("launch",        launchAction);
		actionmap.put("delete-site",   deleteSiteAction);
		actionmap.put("about",         aboutAction);
		InputMap inputmap = new InputMap();
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, Event.SHIFT_MASK), "site-property");  // Shift+Enter

		SiteDropRegister siteDropRegister = new SiteDropRegister(this);
		// r[
		tab = new JTabbedPane();
		lists = new ArrayList();
		for (int i=0; i<siteCategories.size(); i++) {
			SiteCategory cat = (SiteCategory) siteCategories.get(i);
			SiteListBox list = new SiteListBox(this, cat);
			JScrollPane scrollPane = new JScrollPane(list);
			scrollPane.setBorder(new EmptyBorder(10,10,10,10));
			tab.addTab(cat.getName(), scrollPane);
			lists.add(list);
			SwingUtilities.replaceUIActionMap(list, actionmap);
			SwingUtilities.replaceUIInputMap(list, JComponent.WHEN_FOCUSED, inputmap);
			// hbv\ɂ
    	    new DropTarget(list, DnDConstants.ACTION_COPY_OR_MOVE, siteDropRegister, true);
		}
		tab.setSelectedIndex(siteCategories.size()-1);	// TvIԂ
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(tab, BorderLayout.CENTER);
		JToolBar toolbar = new JToolBar("Kandata");
		toolbar.setFloatable(false);	// Ȃ
		toolbar.add(exitAction);
		toolbar.addSeparator();
		toolbar.add(launchAction);
		toolbar.add(sitePropertyAction);
		//toolbar.add(newSiteAction);
		toolbar.add(deleteSiteAction);
		toolbar.addSeparator();
		toolbar.add(aboutAction);
		getContentPane().add(toolbar, BorderLayout.NORTH);


		//setDefaultCloseOperation(EXIT_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				exitApplication();
			}
		});
//		setSize(480, 480);
		setSize(480, 0);
		setVisible(true);

		// EBhEcɐL΂ȂJĂB
		// I܂ł̃AvƂ̓`bgႤˁI(-o-;
		new GrowWindowThread(this, 480, 480).start();
	}

	/** AvP[VIB */
	void exitApplication() {
		storeEnv();
		System.exit(0);
	}

	/** IꂽTCg擾BIĂȂ <code>null</code> ԂB*/
	Site getSelectedSite() {
		// IꂽJeS
		int curcat = tab.getSelectedIndex();
		if (curcat == -1) return null;
		SiteCategory cat = (SiteCategory) siteCategories.get(curcat);
		JList list = (JList) lists.get(curcat);
		// XgIꂽTCg擾
		int cursite = list.getSelectedIndex();
		if (cursite == -1) return null;
		Site site = cat.getSiteInfo(cursite);
		return site;
	}

	/** IꂽTCg̃vpeBҏW. */
	void newSite() {
		// IꂽJeS
		int curcat = tab.getSelectedIndex();
		if (curcat == -1) return;
		SiteCategory cat = (SiteCategory) siteCategories.get(curcat);
		SiteListBox list = (SiteListBox) lists.get(curcat);
		// _CAO\
		Site newSite = SiteInfoPane.showModal(this, "VTCg̓o^", null);
		if (newSite == null) return; 	// cancel
		cat.addSiteInfo(newSite);
		list.fireChanged();
	}
	/** IꂽTCg̃vpeBҏW. */
	void addSite(Site site) {
		// IꂽJeS
		int curcat = tab.getSelectedIndex();
		if (curcat == -1) return;
		SiteCategory cat = (SiteCategory) siteCategories.get(curcat);
		SiteListBox list = (SiteListBox) lists.get(curcat);
		// TCgǉ
		cat.addSiteInfo(site);
		list.fireChanged();
	}

	/** IꂽTCg̃vpeBҏW. */
	void editProperty() {
		// IꂽJeS
		int curcat = tab.getSelectedIndex();
		if (curcat == -1) return;
		SiteCategory cat = (SiteCategory) siteCategories.get(curcat);
		SiteListBox list = (SiteListBox) lists.get(curcat);
		// XgIꂽTCg擾
		int cursite = list.getSelectedIndex();
		if (cursite == -1) return;
		Site site = cat.getSiteInfo(cursite);
		// _CAO\
		Site newSite = SiteInfoPane.showModal(this, "TCg̕ҏW", site);
		if (newSite == null) return; 	// cancel
		cat.setSiteInfo(cursite, newSite);
		list.fireChanged();
	}

	/** IꂽTCgN. */
	void launch() {
		// IꂽJeS
		int curcat = tab.getSelectedIndex();
		if (curcat == -1) return;
		SiteCategory cat = (SiteCategory) siteCategories.get(curcat);
		JList list = (JList) lists.get(curcat);
		// XgIꂽTCg擾
		int cursite = list.getSelectedIndex();
		if (cursite == -1) return;
		Site site = cat.getSiteInfo(cursite);

		// ʃvZXŎsi񓯊jFIX ME
		String command = "java -cp kandata_launcher.jar kandata.client.http.HttpConnector "+site.getUrl();
		MdShellEnv shellenv = new MdShellEnv();
		shellenv.setIn(System.in);
		shellenv.setOut(System.out);
		shellenv.setErr(System.err);
		int rc = MdShellUtilExec.exec(shellenv, command+"&");	//@@@ TODO:s烁bZ[W{bNXo
		System.out.println(site.getUrl()+" rc="+rc);
/*	ȉ̃\[Xł͂܂ȂBwhy?
		try {
			Process process = Runtime.getRuntime().exec(command);
		}
		catch (Exception e) {
			e.printStackTrace();
			showMessageBox("vZX̋NɎs܂", e);
		}
*/
	}

	/** IꂽTCg폜() */
	int deleteSite() {
		// IꂽJeS
		int curcat = tab.getSelectedIndex();
		if (curcat == -1) return 0;
		SiteCategory cat = (SiteCategory) siteCategories.get(curcat);
		SiteListBox list = (SiteListBox) lists.get(curcat);
		// XgIꂽTCg擾
		int[] indeces = list.getSelectedIndices();
		if (indeces == null || indeces.length == 0) return 0;
		// ₢킹B
		String message;
		if (indeces.length==1) {
			Site site = cat.getSiteInfo(indeces[0]);
			message = site.getName() + " 폜܂H";
		}
		else {
			message = "" + indeces.length + " ̃TCg폜܂H";
		}
		int rc = JOptionPane.showConfirmDialog(this, message,
					"TCg̍폜", JOptionPane.YES_NO_OPTION);
		if (rc != JOptionPane.YES_OPTION) return 0;
		// 폜ĂB
		for (int i=indeces.length-1; i>=0; i--) {
			cat.removeSiteInfo(indeces[i]);
		}
		list.fireChanged();
		return indeces.length;
	}

	/** [ŨfBNgۑꂽǂݍށB*/
	ArrayList loadEnv() {
		System.out.println("loadEnv()");
		// ǂݍރt@C̃pX
		String dir = System.getProperty("user.home") + File.separator + ".KandataLauncher";
		String path = dir + File.separator + "KandataLauncher.properties";
		// t@C͂B
		Properties prop = new Properties();
		FileInputStream in = null;
		try {
			in = new FileInputStream(path);
			prop.load(in);
		}
		catch (IOException e) {
			//showMessageBox("̓ǂݍ݂Ɏs܂B\n"+path, e);
			return null;
		}
		finally {
			if (in != null) try { in.close(); } catch (IOException e) {}
		}
		// ݒt@CǂݍށB
		System.out.println("loadEnv() ݒt@CǂݍށB");
		int catsize = Integer.parseInt(prop.getProperty("siteCategories.size", "0"));
		ArrayList siteCategories = new ArrayList();
		for (int i=0; i<catsize; i++) {
			String catName = prop.getProperty("siteCategories."+i+".name");
			if (catName != null) {
				SiteCategory cat = new SiteCategory(catName);
				int sitesize = Integer.parseInt(prop.getProperty("siteCategories."+i+".size", "0"));
				for (int j=0; j<sitesize; j++) {
					String url        = prop.getProperty("siteCategories."+i+"."+j+".url");
					String clientType = prop.getProperty("siteCategories."+i+"."+j+".clientType");
					String version    = prop.getProperty("siteCategories."+i+"."+j+".version");
					String name       = prop.getProperty("siteCategories."+i+"."+j+".name");
					String desc       = prop.getProperty("siteCategories."+i+"."+j+".desc");
					String iconName   = prop.getProperty("siteCategories."+i+"."+j+".iconName");
					String iconExt = prop.getProperty("siteCategories."+i+"."+j+".iconExt");
					// ACRǂݍ
					Image  icon = null;
					byte[] byteArray = null;
					if (iconName != null) {
						icon = Toolkit.getDefaultToolkit().createImage(dir+File.separator+iconName);
						try {
							byteArray = Utilities.getByteArray(new URL(dir+File.separator+iconName));
						} catch (Exception e) {
						}
					}
					Site site = new Site(url, clientType, version, name, desc, icon);
					site.setIconEx(byteArray, iconExt);
					cat.addSiteInfo(site);
				}
				siteCategories.add(cat);
			}
		}
		return siteCategories;
	}

	/**
	 * [ŨfBNgɕۑB
	 * z[fBNg .KandataLauncher/ ƂfBNg쐬Ă܂B
	 */
	void storeEnv() {
		System.out.println("storeEnv()");
		// ǂݍރt@C̃pX
		String dir = System.getProperty("user.home") + File.separator + ".KandataLauncher";
		new File(dir).mkdirs();
		String path = dir + File.separator + "KandataLauncher.properties";
		// ݒt@Cɏo͂B
		Properties prop = new Properties();
		prop.setProperty("siteCategories.size", ""+siteCategories.size());
		for (int i=0; i<siteCategories.size(); i++) {
			SiteCategory cat = (SiteCategory) siteCategories.get(i);
			prop.setProperty("siteCategories."+i+".name", cat.getName());
			prop.setProperty("siteCategories."+i+".size", ""+cat.getSize());
			for (int j=0; j<cat.getSize(); j++) {
				Site site = (Site) cat.getSiteInfo(j);
				prop.setProperty("siteCategories."+i+"."+j+".url", site.getUrl());
				if (site.getClientType() != null) {
					prop.setProperty("siteCategories."+i+"."+j+".clientType", site.getClientType());
				}
				if (site.getVersion() != null) {
					prop.setProperty("siteCategories."+i+"."+j+".version", site.getVersion());
				}
				prop.setProperty("siteCategories."+i+"."+j+".name", site.getName());
				prop.setProperty("siteCategories."+i+"."+j+".desc", site.getDesc());
				// ACRۑ
				if (site.getIconExt() != null) {
					String iconName = ""+ i + "." + j + site.getIconExt();
					prop.setProperty("siteCategories."+i+"."+j+".iconName", iconName);
					prop.setProperty("siteCategories."+i+"."+j+".iconExt", site.getIconExt());
					byte[] byteArray = site.getIconByteArray();
					if (byteArray != null) {
						BufferedOutputStream out = null;
						try {
							String iconPath = dir + File.separator + iconName;
							out = new BufferedOutputStream(new FileOutputStream(new File(iconPath)));
							out.write(byteArray, 0, byteArray.length);
						}
						catch (IOException e) {
						}
						finally {
							if ( out != null ) try { out.close(); } catch (IOException e) {}
						}
					}
				}
			}
		}
		// t@Cɏo͂B
		FileOutputStream out = null;
		try {
			out = new FileOutputStream(path);
			prop.store(out, "KandataLauncher");
		}
		catch (IOException e) {
			// ǂH
			showMessageBox("̕ۑɎs܂B\n"+path, e);
		}
		finally {
			try { out.close(); } catch (IOException e) {}
		}
	}

	/** ftHg̃TCgJeSƃTv쐬܂B */
	ArrayList createDefaultSiteCategories() {
		System.out.println("createDefaultSiteCategories()");
		ArrayList siteCategories = new ArrayList();
		// fB
		siteCategories.add(new SiteCategory("Cɓ"));
		siteCategories.add(new SiteCategory("d"));
		siteCategories.add(new SiteCategory(""));
		siteCategories.add(new SiteCategory("̑"));
		SiteCategory samples = new SiteCategory("Tv");
		Site site = new Site(
			"http://localhost:8080/kandata-hello/servlet/kandata.server.http.ServletServer",
			null,
			null,
			"HelloKandata(localhost)",
			"ƂȒPȃTvł",
			ApplicationResources.loadImage("kandata-hello.png"));
		try {
			byte[] byteArray = Utilities.getByteArray(ApplicationResources.getUrl("kandata-hello.png"));
			site.setIconEx(byteArray, ".png");
		} catch (IOException e) {
			e.printStackTrace();
		}
		samples.addSiteInfo(site);
		site = new Site(
			"http://localhost:8080/kandata-roomreservation/servlet/kandata.server.http.ServletServer",
			null,
			null,
			"c\VXe(localhost)",
			"ƖɗȃTvł",
			ApplicationResources.loadImage("kandata-roomreservation.png"));
		try {
			byte[] byteArray = Utilities.getByteArray(ApplicationResources.getUrl("kandata-roomreservation.png"));
			site.setIconEx(byteArray, ".png");
		} catch (IOException e) {
			e.printStackTrace();
		}
		samples.addSiteInfo(site);
		siteCategories.add(samples);
		return siteCategories;
	}

	/** bZ[WBOX\܂. */
	void showMessageBox(String message, Throwable t) {
		StringWriter st = new StringWriter();
		t.printStackTrace(new PrintWriter(st));
		JOptionPane.showMessageDialog(this, message+"\n"+st.toString());
	}

	public static void main(String[] args) {
		new KandataLauncher();
	}
	
}
