
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import java.io.*;
import java.text.Collator;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public class MdShellDirDirectoryRoot
	extends MdShellDirDirectoryAbstract
{
	public MdShellDirDirectoryRoot()
	{
		setType(ROOT);
		setName(SZ_PROTOCOL[getType()]);
	}

	public String getShortName()
	{
		return "";
	}

	public boolean canRead()
	{
		return true;
	}

	public boolean canWrite()
	{
		return true;
	}

	public MdShellDirDirectoryAbstract getParentDirectory()
	{
		return null;
	}

	public MdShellDirDirectoryAbstract getChildDirectory(String strSubDirectory)
	{
		return null;
	}

	public Vector listDirectory(MdShellEnv shellenv,int iSelect,String strRe)
	{
		Vector vecList=new Vector(1024);
		File[] filesInRoot=File.listRoots();
		for(int index=0;index<filesInRoot.length;index++)
		{
			File fileLook=filesInRoot[index];
			if(MdShellDef.IS_DEBUG)System.out.println(fileLook.getPath());
			vecList.addElement((MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(shellenv,MdShellDirFactory.native2uri(fileLook.getPath()),true));
		}

		buildFtpServerList(shellenv,vecList);

		Collator collator=Collator.getInstance();
		collator.setStrength(Collator.PRIMARY);
		collator.setDecomposition(Collator.FULL_DECOMPOSITION);
		Collections.sort(vecList,new MdShellFileNameComparator(getCollatorInstance()));

		return vecList;
	}

	private void buildFtpServerList(MdShellEnv shellenv,Vector vecList)
	{
		try{
			File fileLoad=new File(MdShellDef.FILE_DEF_FTP);
			if(fileLoad.exists()==false)
			{
				return;
			}
			BufferedReader reader=new BufferedReader(new FileReader(fileLoad));
			for(;;)
			{
				String strRead=reader.readLine();
				if(strRead==null)
				{
					break;
				}
				StringTokenizer toknizerTab=new StringTokenizer(strRead,"\t\n",false);

				try{
					MdShellFtpServerNode ftpservernode=new MdShellFtpServerNode();
					ftpservernode.strHostName=toknizerTab.nextToken();
					ftpservernode.strUser=toknizerTab.nextToken();
					ftpservernode.strPassword=toknizerTab.nextToken();

					vecList.addElement(new MdShellDirDirectoryFtpClient(shellenv,ftpservernode.strHostName+"/."));
				}catch(NoSuchElementException ex){
					// None.
				}
			}
			reader.close();
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
	}

	public boolean delete()
	{
		return false;
	}
}


