
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.util.cat;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.util.Vector;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.io.*;
import java.util.*;
import java.text.SimpleDateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Cat
{
	/**
	 * list files in this directory.
	 */
	public int process(MdShellEnv shellenv,String[] strArgs)
	{
		processInternal(shellenv,strArgs);
		return 0;
	}

	private final void processInternal(MdShellEnv shellenv,String[] strArgs)
	{

		LongOpt[] longOptions = { 
			new LongOpt("show-ends",	LongOpt.NO_ARGUMENT, null, 'E'),
			new LongOpt("number",		LongOpt.NO_ARGUMENT, null, 'n'),
			new LongOpt("recursive",	LongOpt.NO_ARGUMENT, null, 'r'),
			new LongOpt("help",		LongOpt.NO_ARGUMENT, null, '?'),
			new LongOpt("version",		LongOpt.NO_ARGUMENT, null, 'V')
		};

		boolean isRecursive=false;

		Getopt g=new Getopt("cat",strArgs,"EnrV?",longOptions);
		int c;
		while((c=g.getopt()) != -1)
		{
			switch (c) {
				case 'E':
					break;
				case 'n':
					break;
				case 'r':
					isRecursive=true;
					break;
				case 'V':
					break;
				case '?': // help
					BufferedReader reader=new BufferedReader(new InputStreamReader((Cat.class).getResourceAsStream("CatUsage.txt")));
					try {
						String strLine=null;
						while((strLine=reader.readLine())!=null)
						{
							shellenv.getOut().println(strLine);
						}
						reader.close();
					}catch(IOException ex){
						System.out.println(ex.toString());
						ex.printStackTrace();
					}
					return;
			}
		}

		String strFileRegExp=null;
		{
			int optind=g.getOptind();
			if (optind<strArgs.length)
			{
				strFileRegExp=MdShellUtilString.eraseChar(strArgs[g.getOptind()],'*');
			}
		}

		Vector vecList=null;
		if(strFileRegExp==null)
		{
			return;
		}

		if(isRecursive)
		{
			vecList=shellenv.getCurrentDirectory().listDirectoryWithSubDirectory(shellenv,MdShellDirNodeInfo.SELECT_FILE,strFileRegExp);
		}
		else
		{
			vecList=shellenv.getCurrentDirectory().listDirectory(shellenv,MdShellDirNodeInfo.SELECT_FILE,strFileRegExp);
		}

		for(int index=0;index<vecList.size();index++)
		{
			MdShellDirNodeInterface dirLook=(MdShellDirNodeInterface)vecList.elementAt(index);
			cat(shellenv,(MdShellDirFileAbstract)dirLook);
		}
	}

	public void cat(MdShellEnv shellenv,MdShellDirFileAbstract dirLook)
	{
		InputStream inStream=dirLook.getInputStream();
		BufferedReader reader=new BufferedReader(new InputStreamReader(inStream));
		String strLine=null;
		try {
			while((strLine=reader.readLine())!=null)
			{
				shellenv.getOut().println(strLine);
			}
			reader.close();
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
	}
}


