
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.eng;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.util.MdShellUtilString;
import java.io.*;
import java.text.Collator;
import java.util.*;

public class MdShellEnv
{
	private MdShellCmdList commandlist=new MdShellCmdList();
	private MdShellFileHistory historyFile=new MdShellFileHistory();
	private MdShellDirectoryHistory historyDirectory=new MdShellDirectoryHistory();

	/**
	 * Current Directory.
	 */
	private MdShellDirDirectoryAbstract dirDirectoryCurrent=null;
	private MdShellDirFileAbstract dirDirectoryStart=null;


	//private MdShellStreamConnectThread childstreamthread=null;

	/**
	 * 
	 */
	private Collator collator=null;


	public void init()
	{
		try{
			dirDirectoryStart=(MdShellDirFileFileSystem)MdShellDirFactory.getInstance(this,MdShellDirFactory.native2uri(new File(".").getCanonicalPath()),false);
		}catch(IOException ex){
			getOut().println(ex.toString());
			ex.printStackTrace(getOut());
		}
		dirDirectoryCurrent=dirDirectoryStart.getPath();

		historyFile.init();
		historyDirectory.init();

		// add current directory into directory history.
		getDirectoryHistory().addHistory(dirDirectoryCurrent.getName());

		try{
			Hashtable hashFtpServerList=new Hashtable(256);
			File fileLoad=new File(MdShellDef.FILE_DEF_FTP);
			if(fileLoad.exists()==false)
			{
				return;
			}
			BufferedReader reader=new BufferedReader(new FileReader(fileLoad));
			for(;;)
			{
				String strRead=reader.readLine();
				if(strRead==null)
				{
					break;
				}
				StringTokenizer toknizerTab=new StringTokenizer(strRead,"\t\n",false);

				try{
					MdShellFtpServerNode ftpservernode=new MdShellFtpServerNode();
					ftpservernode.strHostName=toknizerTab.nextToken();
					ftpservernode.strUser=toknizerTab.nextToken();
					ftpservernode.strPassword=toknizerTab.nextToken();

					//System.out.println("ftp server node: "+ftpservernode.toString());
					hashFtpServerList.put(ftpservernode.strHostName,ftpservernode);
				}catch(NoSuchElementException ex){
					// None.
				}
			}
			reader.close();
			setFtpServerList(hashFtpServerList);
		}catch(IOException ex){
			getOut().println(ex.toString());
			ex.printStackTrace(getOut());
		}
	}

	public void save()
	{
		historyFile.save();
		historyDirectory.save();
	}

	public void close()
	{
	}

	public MdShellDirDirectoryAbstract getCurrentDirectory()
	{
		return dirDirectoryCurrent;
	}

	public void setCurrentDirectory(MdShellDirDirectoryAbstract dirDirectoryCurrent)
	{
		this.dirDirectoryCurrent=dirDirectoryCurrent;
	}

	public void cdParentDirectory()
	{
		dirDirectoryCurrent=dirDirectoryCurrent.getParentDirectory();
	}

	//public void cdChildDirectory(String strSubdirectory)
	//{
	//	dirDirectoryCurrent.getChildDirectory(strSubdirectory);
	//}

	/**
	 * muriyari 
	 */
	public Vector getFileHistory()
	{
		return historyFile.getHistory();
	}

	public MdShellHistory getDirectoryHistory()
	{
		return historyDirectory;
	}

	public MdShellCmdList getCommandList()
	{
		return commandlist;
	}

	public InputStream getChildProcessInputStream()
	{
		return getIn();
		//try{
		//	closeChildProcessInputStream();
		//	PipedInputStream inStream=new PipedInputStream();
		//	PipedOutputStream outStream=new PipedOutputStream(inStream);
		//	childstreamthread=new MdShellStreamConnectThread(getInputStream(),outStream);
		//	childstreamthread.setSingleByteMode(true);
		//	childstreamthread.start();
		//	return inStream;
		//}catch(IOException ex){
		//	System.out.println(ex.toString());
		//	ex.printStackTrace();
		//}
		//return null;
	}

	//public void closeChildProcessInputStream()
	//{
	//	if(childstreamthread!=null)
	//	{
	//		childstreamthread.close();
	//	}
	//	childstreamthread=null;
	//}

	/**
	 * The standardization of the comparison.
	 */
	public final Collator getCollatorInstance()
	{
		if(collator==null)
		{
			collator=Collator.getInstance();
			collator.setStrength(Collator.PRIMARY);
			collator.setDecomposition(Collator.FULL_DECOMPOSITION);
		}
		return collator;
	}

	private String strOriginalLine=null;
	private StringTokenizer toknizerTab=null;
	public final void clearLine()
	{
		// refresh string tokenizer.
		strOriginalLine=null;
		toknizerTab=null;
	}

	public final boolean hasMoreTokensWithoutInput()
	{
		return toknizerTab.hasMoreTokens();
	}

	public final String getOriginalReadLine()
	{
		return strOriginalLine;
	}

	public final String[] getArgsArray()
	{
		Vector vecArgs=new Vector();
		for(;hasMoreTokensWithoutInput();)
		{
			String strNextLine=getNextLine();
			vecArgs.addElement(strNextLine);
		}
		String[] args=new String[vecArgs.size()];
		for(int index=0;index<vecArgs.size();index++)
		{
			args[index]=(String)vecArgs.elementAt(index);
		}
		return args;
	}

	public final String getNextLine()
	{
		// first try to read from tokenizer.
		//String strRead=tryReadTokenFromToken();
		//if(strRead!=null)
		//{
		//	return strRead;
		//}

		promptInputIfNoDataExist();

		String strRead=tryReadTokenFromToken();
		if(strRead!=null)
		{
			return strRead;
		}

		return null;
	}

	public final void promptInputIfNoDataExist()
	{
		if(toknizerTab!=null)
		{
			if(toknizerTab.hasMoreTokens()==false)
			{
				toknizerTab=null;
			}
		}
		if(toknizerTab==null)
		{
			String strLine=MdShellUtilString.readLine(getIn());
			strOriginalLine=strLine;
			toknizerTab=new StringTokenizer(strLine," \t\n",false);
		}
	}

	private final String tryReadTokenFromToken()
	{
		if(toknizerTab!=null)
		{
			String strSubLine=null;
			try{
				strSubLine=toknizerTab.nextToken();
				return strSubLine;
			}catch(NoSuchElementException ex){
				toknizerTab=null;
			}
		}
		return null;
	}

	private InputStream currentIn=null;
	public void setIn(InputStream inputArg)
	{
		currentIn=inputArg;
	}
	public InputStream getIn()
	{
		return currentIn;
	}

	private PrintStream currentOut=null;
	public void setOut(PrintStream printArg)
	{
		currentOut=printArg;
	}
	public PrintStream getOut()
	{
		return currentOut;
	}

	private PrintStream currentErr=null;
	public void setErr(PrintStream printArg)
	{
		currentErr=printArg;
	}
	public PrintStream getErr()
	{
		return currentErr;
	}

	private Hashtable hashFtpServerList=null;
	public void setFtpServerList(Hashtable hashFtpServerList)
	{
		this.hashFtpServerList=hashFtpServerList;
	}
	public Hashtable getFtpServerList()
	{
		return this.hashFtpServerList;
	}
}



