
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
//import java.text.Collator;
//import java.util.Vector;

import java.io.*;
import java.util.*;
import java.text.*;

public class MdShellCommandMmake
	extends MdShellCmdDefault
{
	public MdShellCommandMmake()
	{
		setCommand("mmake");
		setDisplayString("compile java source code in current and child directory.");
	}

	public final boolean isRebuild=true;
	public final String CLASS_PATH=".;xerces.jar";//"gnu-regexp-1.0.8.jar;java-getopt-1.0.7.jar";

	public void processCommand(MdShellEnv shellenv)
	{
		try{
			Vector vecTotalDirectory=shellenv.getCurrentDirectory().listDirectoryWithSubDirectory(shellenv,MdShellDirNodeInfo.SELECT_FILE,".java$");

			String strCurrentDirectory=shellenv.getCurrentDirectory().getName();
			int iBaseLength=strCurrentDirectory.length();

			HashMap hashDirectoryToCompile=new HashMap(8192);
			for(int index=0;index<vecTotalDirectory.size();index++)
			{
				//{
				//	MdShellDirNodeInterface lookWrk=(MdShellDirNodeInterface)vecTotalDirectory.elementAt(index);
				//	shellenv.getOut().println(lookWrk.getName());
				//}

				if(vecTotalDirectory.elementAt(index) instanceof MdShellDirFileAbstract)
				{
					MdShellDirFileAbstract look=(MdShellDirFileAbstract)vecTotalDirectory.elementAt(index);
					if(look.getName().endsWith(".java"))
					{
						String strLook=MdShellDirFactory.getPathWithoutShortName(look.getName());
						if(hashDirectoryToCompile.get(strLook)==null)
						{
							//shellenv.getOut().println("before: "+strLook);
							if(strLook.length()>iBaseLength)
							{
								strLook=strLook.substring(iBaseLength+1);
							}
							else
							{
								strLook=strLook.substring(iBaseLength);
							}
							//shellenv.getOut().println("after:  "+strLook);
							hashDirectoryToCompile.put(strLook,look);
						}
					}
				}
			}

			if(hashDirectoryToCompile.size()==0)
			{
				shellenv.getOut().println("There was no necessary file of build.");
				return;
			}

			StringBuffer strbufCompile=new StringBuffer("javac -g:none -classpath "+CLASS_PATH);
	
			Set setDir=hashDirectoryToCompile.entrySet();
	
			String strSeparator=System.getProperty("file.separator");

			for(Iterator iterator=setDir.iterator();iterator.hasNext();)
			{
				Map.Entry mapDirectory=(Map.Entry)iterator.next();
				if(mapDirectory.getKey().toString().length()>0)
				{
					strbufCompile.append(" "+MdShellDirFactory.uri2native((String)mapDirectory.getKey())+strSeparator+"*.java");
				}
				else
				{
					strbufCompile.append(" "+MdShellDirFactory.uri2native((String)mapDirectory.getKey())+"*.java");
				}
			}

			MdShellUtilExec.exec(shellenv,strbufCompile.toString());
		}catch(Exception ex){
			shellenv.getOut().println(ex);
			ex.printStackTrace();
		}
	}
}



