
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.eng.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.io.*;
import java.util.*;

public class MdShellCommandBase64
	extends MdShellCmdDefault
{
	public MdShellCommandBase64()
	{
		setCommand("base64");
		setDisplayString("Mime Base64 encoding and decoding. [experimental]");
	}

	public void processCommand(MdShellEnv shellenv)
		throws MdShellCancelException
	{
		Vector vecList=new Vector();
		vecList.addElement("encode");
		vecList.addElement("decode");

		MdShellListSelection.showVectorListWithNumberAndString(shellenv,vecList,new MdShellDefaultStringFormatter());
		shellenv.getOut().print("select what to select: ");
		MdShellDefaultStringFormatter formatter=new MdShellDefaultStringFormatter();
		String strSubCommand=formatter.format(MdShellListSelection.selectFromList(shellenv,vecList,formatter,shellenv.getNextLine()));

		if(strSubCommand==null)
		{
			throw new MdShellCancelException();
		}

		if(strSubCommand.equals("encode"))
		{
			MdShellDirFileAbstract dirNodeInterface=MdShellSelectFileUtil.selectFile(shellenv);
			if(dirNodeInterface!=null)
			{
				System.out.println("encode output to "+dirNodeInterface.getName()+".base64.enc");
				encodeFile(shellenv,dirNodeInterface);
			}
		}
		else if (strSubCommand.equals("decode"))
		{
			MdShellDirFileAbstract dirNodeInterface=MdShellSelectFileUtil.selectFile(shellenv);
			if(dirNodeInterface!=null)
			{
				System.out.println("decode output to "+dirNodeInterface.getName()+".base64.dec");
				decodeFile(shellenv,dirNodeInterface);
			}
		}
	}

	private void encodeFile(MdShellEnv shellenv,MdShellDirFileAbstract dirfileabstract)
	{
		try{
			InputStream inStream=new BufferedInputStream(dirfileabstract.getInputStream());
			MdShellDirFileAbstract dirfileOut=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,dirfileabstract.getName()+".base64.enc",false);
			OutputStream outStream=new MdShellBase64OutputStream(new BufferedOutputStream(dirfileOut.getOutputStream()));
			for(;;)
			{
				int iRead=inStream.read();
				if(iRead<0)break;
				outStream.write((byte)iRead);
			}
			inStream.close();
			outStream.flush();
			outStream.close();
			dirfileOut.setLastModified(dirfileabstract.getLastModified());
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
	}

	private void decodeFile(MdShellEnv shellenv,MdShellDirFileAbstract dirfileabstract)
	{
		try{
			MdShellDirFileAbstract dirfileOut=(MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv,dirfileabstract.getName()+".base64.dec",false);
			InputStream inStream=new MdShellBase64InputStream(new BufferedInputStream(dirfileabstract.getInputStream()));
			OutputStream outStream=new BufferedOutputStream(dirfileOut.getOutputStream());
			for(;;)
			{
				int iRead=inStream.read();
				if(iRead<0)break;
				outStream.write((byte)iRead);
			}
			inStream.close();
			outStream.flush();
			outStream.close();
			dirfileOut.setLastModified(dirfileabstract.getLastModified());
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
	}
}


