/*
 * Decompiled with CFR 0.152.
 */
package kandata.server.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kandata.KandataServerException;
import kandata.server.KandataAction;
import kandata.server.KandataClientContext;
import kandata.server.KandataEvent;
import kandata.server.KandataServer;
import kandata.server.KandataServerContext;

public class ServletServer
extends HttpServlet
implements KandataServerContext {
    static final boolean TRACE_ENABLE = true;
    private static final String CONFIG_FILENAME = "kandata.properties";
    protected KandataServer server;
    protected String serverClassName;
    protected String serverResourcePath;
    protected String clientEntryClassName;
    protected String clientClassPath;
    protected String clientResourcePath;
    private HashMap clientContextMap = new HashMap();
    private HashMap actionMap = new HashMap();

    void TRACE(String message) {
        this.getServletContext().log(message);
    }

    void TRACE(String message, Throwable ex) {
        this.getServletContext().log(message, ex);
    }

    public void init() throws ServletException {
        this.TRACE("<<< init() >>>");
        super.init();
        this.loadConfiguration(CONFIG_FILENAME);
        try {
            this.server = (KandataServer)Class.forName(this.serverClassName).newInstance();
        }
        catch (Exception e) {
            this.TRACE("create KandataServer failed:" + this.serverClassName, e);
        }
        this.server.init(this);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            long now = System.currentTimeMillis();
            ObjectInputStream in = new ObjectInputStream((InputStream)request.getInputStream());
            String id = (String)in.readObject();
            String command = (String)in.readObject();
            int args_len = in.readInt();
            this.TRACE("  ID=" + id + " command=[" + command + "] args_len=" + args_len + " -------------------");
            Object[] args = new Object[args_len];
            for (int i = 0; i < args_len; ++i) {
                args[i] = in.readObject();
                this.TRACE("  args[" + i + "]=" + args[i]);
            }
            in.close();
            KandataClientContext context = (KandataClientContext)this.clientContextMap.get(id);
            KandataServerException ex = null;
            Object ret = null;
            try {
                if (command.charAt(0) == '@') {
                    if (command.equals("@connect")) {
                        if (context != null) {
                            throw new KandataServerException("already connected", null);
                        }
                        context = new KandataClientContext(now);
                        this.clientContextMap.put(context.getId(), context);
                    } else if (context == null) {
                        throw new KandataServerException("not connected", null);
                    }
                    ret = this.invokeSystemCommand(context, command, args);
                    if (command.equals("@disconnect")) {
                        this.clientContextMap.remove(id);
                    }
                } else {
                    if (context == null) {
                        throw new KandataServerException("not connected", null);
                    }
                    ret = this.invokeCommand(context, command, args);
                }
            }
            catch (KandataServerException e) {
                ex = e;
            }
            this.TRACE("  ret=" + ret);
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
            out.writeObject(ret);
            out.writeObject(ex);
            out.close();
            context.setLastAccessTimeMillis(now);
        }
        catch (ClassNotFoundException e) {
            this.TRACE("serialize failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokeSystemCommand(KandataClientContext context, String command, Object[] args) throws KandataServerException {
        if (command.equals("@getClass")) {
            byte[] byArray;
            String classname = (String)args[0];
            String path = this.getWebInfPath() + File.separator + this.clientClassPath + File.separator + classname.replace('.', File.separatorChar) + ".class";
            FileInputStream in = null;
            try {
                try {
                    File file = new File(path);
                    byte[] buf = new byte[(int)file.length()];
                    in = new FileInputStream(file);
                    in.read(buf, 0, (int)file.length());
                    byArray = buf;
                    Object var11_18 = null;
                    if (in == null) return byArray;
                }
                catch (IOException e) {
                    throw new KandataServerException("load class failed: classname=" + classname + " path=" + path, e);
                }
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e2) {
                // empty catch block
                return byArray;
            }
            in.close();
            return byArray;
        }
        if (command.equals("@getResource")) {
            byte[] byArray;
            String resourcename = (String)args[0];
            String path = this.getWebInfPath() + File.separator + this.clientResourcePath + resourcename;
            FileInputStream in = null;
            try {
                try {
                    File file = new File(path);
                    byte[] buf = new byte[(int)file.length()];
                    in = new FileInputStream(file);
                    in.read(buf, 0, (int)file.length());
                    byArray = buf;
                    Object var14_23 = null;
                    if (in == null) return byArray;
                }
                catch (IOException e) {
                    throw new KandataServerException("load resource failed: resourcename=" + resourcename + " path=" + path, e);
                }
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e3) {
                // empty catch block
                return byArray;
            }
            in.close();
            return byArray;
        }
        if (command.equals("@connect")) {
            this.server.connected(context);
            return context.getId();
        }
        if (command.equals("@disconnect")) {
            this.server.disconnected(context);
            return null;
        }
        if (command.equals("@getEntryClassName")) {
            return this.clientEntryClassName;
        }
        this.TRACE("\u672a\u5b9a\u7fa9\u306e\u30b3\u30de\u30f3\u30c9\u3067\u3059 command=" + command);
        throw new KandataServerException("illegal command:" + command, null);
    }

    protected Object invokeCommand(KandataClientContext context, String command, Object[] args) throws KandataServerException {
        KandataEvent event = new KandataEvent(context, command, args);
        KandataAction action = (KandataAction)this.actionMap.get(command);
        if (action == null) {
            throw new KandataServerException("illegal command:" + command, null);
        }
        Object result = action.execute(event);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadConfiguration(String fname) {
        FileInputStream in = null;
        in = new FileInputStream(this.getWebInfPath() + File.separator + fname);
        Properties prop = new Properties();
        prop.load(in);
        String appname = prop.getProperty("application.name");
        this.serverClassName = prop.getProperty("application.serverclassname");
        this.serverResourcePath = prop.getProperty("application.serverresourcepath");
        this.clientEntryClassName = prop.getProperty("application.cliententryclassname");
        this.clientClassPath = prop.getProperty("application.clientclasspath");
        this.clientResourcePath = prop.getProperty("application.clientresourcepath");
        in.close();
        this.TRACE("application.name=" + appname);
        this.TRACE("application.serverclassname=" + this.serverClassName);
        this.TRACE("application.serverresourcepath=" + this.serverResourcePath);
        this.TRACE("application.cliententryclassname=" + this.clientEntryClassName);
        this.TRACE("application.clientclasspath=" + this.clientClassPath);
        this.TRACE("application.clientresourcepath=" + this.clientResourcePath);
        Object var6_6 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                this.TRACE("load configuration failed.", e);
                Object var6_7 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void destroy() {
        this.server.exit();
    }

    public String getResourcePath() {
        return this.getWebInfPath() + File.separator + this.serverResourcePath;
    }

    private String getWebInfPath() {
        return this.getServletContext().getRealPath("/WEB-INF");
    }

    public void putAction(String command, KandataAction action) {
        this.actionMap.put(command, action);
    }
}

