/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.util.mcd;

import java.util.Collections;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryRoot;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInfo;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFileNameComparator;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellDirectoryNameFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellDirectoryShortNameFormatter;

public class Mcd {
    public static MdShellDirDirectoryAbstract selectDirectory(MdShellEnv shellenv, MdShellDirDirectoryAbstract dirBaseDirectory) throws MdShellCancelException {
        Vector<String> vecList = new Vector<String>();
        if (!(dirBaseDirectory instanceof MdShellDirDirectoryRoot)) {
            vecList.addElement("..");
            vecList.addElement("parent");
        }
        vecList.addElement("child");
        vecList.addElement("history");
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select how to move directory: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strSubCommand = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strSubCommand == null) {
            throw new MdShellCancelException();
        }
        if (strSubCommand.equals("..")) {
            return dirBaseDirectory.getParentDirectory();
        }
        if (strSubCommand.equals("parent")) {
            return Mcd.cdParentDirectory(shellenv, dirBaseDirectory);
        }
        if (strSubCommand.equals("child")) {
            return Mcd.cdChildDirectory(shellenv, dirBaseDirectory);
        }
        if (strSubCommand.equals("history")) {
            return Mcd.cdHistoryDirectory(shellenv, dirBaseDirectory);
        }
        shellenv.getOut().println("not yet implemented.");
        shellenv.getOut().println("current directory: " + dirBaseDirectory.getName());
        shellenv.getOut().println("select directory to move: ");
        return null;
    }

    public static MdShellDirDirectoryAbstract selectDirectoryContinuous(MdShellEnv shellenv, MdShellDirDirectoryAbstract dirBaseDirectory) throws MdShellCancelException {
        MdShellDirNodeInfo dirTargetDirectory = null;
        try {
            MdShellDirDirectoryAbstract dirNextDirectory = dirBaseDirectory;
            while ((dirNextDirectory = Mcd.selectDirectory(shellenv, dirNextDirectory)) != null) {
                shellenv.getOut().println("current target is :" + dirNextDirectory.getName());
                dirTargetDirectory = dirNextDirectory;
            }
        }
        catch (MdShellCancelException mdShellCancelException) {
            // empty catch block
        }
        if (dirTargetDirectory == null) {
            throw new MdShellCancelException();
        }
        shellenv.getOut().println("selected target directory is :" + dirTargetDirectory.getName());
        return dirTargetDirectory;
    }

    private static MdShellDirDirectoryAbstract cdParentDirectory(MdShellEnv shellenv, MdShellDirDirectoryAbstract dirBaseDirectory) throws MdShellCancelException {
        Vector<MdShellDirDirectoryAbstract> vecList = new Vector<MdShellDirDirectoryAbstract>();
        MdShellDirDirectoryAbstract dirLook = dirBaseDirectory;
        while ((dirLook = dirLook.getParentDirectory()) != null) {
            vecList.addElement(dirLook);
        }
        Collections.sort(vecList, new MdShellFileNameComparator(shellenv.getCollatorInstance()));
        MdShellDirectoryNameFormatter formatter = new MdShellDirectoryNameFormatter();
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, formatter);
        shellenv.getOut().print("select directory to move: ");
        MdShellDirDirectoryAbstract dirNewDirectory = (MdShellDirDirectoryAbstract)MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine());
        if (dirNewDirectory == null) {
            throw new MdShellCancelException();
        }
        return dirNewDirectory;
    }

    private static MdShellDirDirectoryAbstract cdChildDirectory(MdShellEnv shellenv, MdShellDirDirectoryAbstract dirBaseDirectory) throws MdShellCancelException {
        Vector vecList = dirBaseDirectory.listDirectory(shellenv, 2, null);
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDirectoryShortNameFormatter());
        shellenv.getOut().print("select directory to move: ");
        MdShellDirectoryShortNameFormatter formatter = new MdShellDirectoryShortNameFormatter();
        MdShellDirDirectoryAbstract dirNewDirectory = (MdShellDirDirectoryAbstract)MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine());
        if (dirNewDirectory == null) {
            throw new MdShellCancelException();
        }
        return dirNewDirectory;
    }

    private static MdShellDirDirectoryAbstract cdHistoryDirectory(MdShellEnv shellenv, MdShellDirDirectoryAbstract dirBaseDirectory) throws MdShellCancelException {
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, shellenv.getDirectoryHistory().getHistory(), new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select directory.: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strDirectoryName = formatter.format(MdShellListSelection.selectFromList(shellenv, shellenv.getDirectoryHistory().getHistory(), formatter, shellenv.getNextLine()));
        if (strDirectoryName == null) {
            throw new MdShellCancelException();
        }
        shellenv.getOut().println("get from history [" + strDirectoryName + "]");
        return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(shellenv, strDirectoryName, true);
    }
}

