/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.dir;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;

public class MdShellDirFileFileSystem
extends MdShellDirFileAbstract {
    private MdShellEnv shellenv = null;
    private File fileMySelf = null;

    public MdShellDirFileFileSystem(MdShellEnv shellenv, File file) {
        this.shellenv = shellenv;
        this.fileMySelf = file;
        this.setType(1);
        try {
            this.setName(MdShellDirFactory.native2uri(this.fileMySelf.getCanonicalPath()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setFileLength(this.fileMySelf.length());
        this.lastModified = this.fileMySelf.lastModified();
        this.bCanWrite = this.fileMySelf.canWrite();
        this.bCanRead = this.fileMySelf.canRead();
    }

    public String getShortName() {
        return MdShellDirFactory.getShortName(this.getName());
    }

    public MdShellDirDirectoryAbstract getPath() {
        if (new File(MdShellDirFactory.uri2native(this.getName())).isDirectory()) {
            return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(this.shellenv, this.getName(), true);
        }
        String strPathWithoutShortName = MdShellDirFactory.getPathWithoutShortName(this.getName());
        return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(this.shellenv, strPathWithoutShortName, true);
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
        this.fileMySelf.setLastModified(lastModified);
    }

    public final InputStream getInputStream() {
        try {
            return new FileInputStream(this.fileMySelf);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            return null;
        }
    }

    public final OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this.fileMySelf);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            return null;
        }
    }

    public boolean delete() {
        return this.fileMySelf.delete();
    }
}

