/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdDefault;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellBase64InputStream;
import jp.ne.nifty.iga.midori.shell.io.MdShellBase64OutputStream;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.util.MdShellSelectFileUtil;

public class MdShellCommandBase64
extends MdShellCmdDefault {
    public MdShellCommandBase64() {
        this.setCommand("base64");
        this.setDisplayString("Mime Base64 encoding and decoding. [experimental]");
    }

    public void processCommand(MdShellEnv shellenv) throws MdShellCancelException {
        MdShellDirFileAbstract dirNodeInterface;
        Vector<String> vecList = new Vector<String>();
        vecList.addElement("encode");
        vecList.addElement("decode");
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select what to select: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strSubCommand = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strSubCommand == null) {
            throw new MdShellCancelException();
        }
        if (strSubCommand.equals("encode")) {
            MdShellDirFileAbstract dirNodeInterface2 = MdShellSelectFileUtil.selectFile(shellenv);
            if (dirNodeInterface2 != null) {
                System.out.println("encode output to " + dirNodeInterface2.getName() + ".base64.enc");
                this.encodeFile(shellenv, dirNodeInterface2);
            }
        } else if (strSubCommand.equals("decode") && (dirNodeInterface = MdShellSelectFileUtil.selectFile(shellenv)) != null) {
            System.out.println("decode output to " + dirNodeInterface.getName() + ".base64.dec");
            this.decodeFile(shellenv, dirNodeInterface);
        }
    }

    private void encodeFile(MdShellEnv shellenv, MdShellDirFileAbstract dirfileabstract) {
        try {
            int iRead;
            BufferedInputStream inStream = new BufferedInputStream(dirfileabstract.getInputStream());
            MdShellDirFileAbstract dirfileOut = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, dirfileabstract.getName() + ".base64.enc", false);
            MdShellBase64OutputStream outStream = new MdShellBase64OutputStream(new BufferedOutputStream(dirfileOut.getOutputStream()));
            while ((iRead = ((InputStream)inStream).read()) >= 0) {
                ((OutputStream)outStream).write((byte)iRead);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).flush();
            ((OutputStream)outStream).close();
            dirfileOut.setLastModified(dirfileabstract.getLastModified());
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
    }

    private void decodeFile(MdShellEnv shellenv, MdShellDirFileAbstract dirfileabstract) {
        try {
            int iRead;
            MdShellDirFileAbstract dirfileOut = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, dirfileabstract.getName() + ".base64.dec", false);
            MdShellBase64InputStream inStream = new MdShellBase64InputStream(new BufferedInputStream(dirfileabstract.getInputStream()));
            BufferedOutputStream outStream = new BufferedOutputStream(dirfileOut.getOutputStream());
            while ((iRead = ((InputStream)inStream).read()) >= 0) {
                ((OutputStream)outStream).write((byte)iRead);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).flush();
            ((OutputStream)outStream).close();
            dirfileOut.setLastModified(dirfileabstract.getLastModified());
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
    }
}

