/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp.util;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Grep {
    private static final int BYTE_OFFSET = 0;
    private static final int COUNT = 1;
    private static final int LINE_NUMBER = 2;
    private static final int QUIET = 3;
    private static final int SILENT = 4;
    private static final int NO_FILENAME = 5;
    private static final int REVERT_MATCH = 6;
    private static final int FILES_WITH_MATCHES = 7;
    private static final int LINE_REGEXP = 8;
    private static final int FILES_WITHOUT_MATCH = 9;
    private static final String PROGNAME = "gnu.regexp.util.Grep";
    private static final String PROGVERSION = "1.01";
    static /* synthetic */ Class class$gnu$regexp$util$Grep;

    private Grep() {
    }

    public static void main(String[] argv) {
        Grep.grep(argv, RESyntax.RE_SYNTAX_GREP, System.out);
    }

    public static int grep(String[] argv, RESyntax syntax, PrintStream out) {
        int c;
        int cflags = 0;
        boolean[] options = new boolean[10];
        LongOpt[] longOptions = new LongOpt[]{new LongOpt("byte-offset", 0, null, 98), new LongOpt("count", 0, null, 99), new LongOpt("no-filename", 0, null, 104), new LongOpt("ignore-case", 0, null, 105), new LongOpt("files-with-matches", 0, null, 108), new LongOpt("help", 0, null, 33), new LongOpt("line-number", 0, null, 110), new LongOpt("quiet", 0, null, 113), new LongOpt("silent", 0, null, 113), new LongOpt("no-messages", 0, null, 115), new LongOpt("revert-match", 0, null, 118), new LongOpt("line-regexp", 0, null, 120), new LongOpt("extended-regexp", 0, null, 69), new LongOpt("fixed-strings", 0, null, 70), new LongOpt("basic-regexp", 0, null, 71), new LongOpt("files-without-match", 0, null, 76), new LongOpt("version", 0, null, 86)};
        Getopt g = new Getopt(PROGNAME, argv, "bchilnqsvxyEFGLV", longOptions);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 98: {
                    options[0] = true;
                    break;
                }
                case 99: {
                    options[1] = true;
                    break;
                }
                case 104: {
                    options[5] = true;
                    break;
                }
                case 105: 
                case 121: {
                    cflags |= 2;
                    break;
                }
                case 108: {
                    options[7] = true;
                    break;
                }
                case 110: {
                    options[2] = true;
                    break;
                }
                case 113: {
                    options[3] = true;
                    break;
                }
                case 115: {
                    options[4] = true;
                    break;
                }
                case 118: {
                    options[6] = true;
                    break;
                }
                case 120: {
                    options[8] = true;
                    break;
                }
                case 69: {
                    syntax = RESyntax.RE_SYNTAX_EGREP;
                    break;
                }
                case 70: {
                    break;
                }
                case 71: {
                    syntax = RESyntax.RE_SYNTAX_GREP;
                    break;
                }
                case 76: {
                    options[9] = true;
                    break;
                }
                case 86: {
                    System.err.println("gnu.regexp.util.Grep 1.01");
                    return 0;
                }
                case 33: {
                    BufferedReader br = new BufferedReader(new InputStreamReader((class$gnu$regexp$util$Grep == null ? (class$gnu$regexp$util$Grep = Grep.class$(PROGNAME)) : class$gnu$regexp$util$Grep).getResourceAsStream("GrepUsage.txt")));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            out.println(line);
                        }
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                    return 0;
                }
            }
        }
        FileInputStream is = null;
        RE pattern = null;
        int optind = g.getOptind();
        if (optind >= argv.length) {
            System.err.println("Usage: java gnu.regexp.util.Grep [OPTION]... PATTERN [FILE]...");
            System.err.println("Try `java gnu.regexp.util.Grep --help' for more information.");
            return 2;
        }
        try {
            pattern = new RE(argv[g.getOptind()], cflags, syntax);
        }
        catch (REException e) {
            System.err.println("Error in expression: " + e);
            return 2;
        }
        int retval = 1;
        if (argv.length >= g.getOptind() + 2) {
            for (int i = g.getOptind() + 1; i < argv.length; ++i) {
                if (argv[i].equals("-")) {
                    if (!Grep.processStream(pattern, System.in, options, argv.length == g.getOptind() + 2 || options[5] ? null : "(standard input)", out)) continue;
                    retval = 0;
                    continue;
                }
                try {
                    is = new FileInputStream(argv[i]);
                    if (!Grep.processStream(pattern, is, options, argv.length == g.getOptind() + 2 || options[5] ? null : argv[i], out)) continue;
                    retval = 0;
                    continue;
                }
                catch (FileNotFoundException e) {
                    if (options[4]) continue;
                    System.err.println("gnu.regexp.util.Grep: " + e);
                }
            }
        } else if (Grep.processStream(pattern, System.in, options, null, out)) {
            retval = 1;
        }
        return retval;
    }

    private static boolean processStream(RE pattern, InputStream is, boolean[] options, String filename, PrintStream out) {
        int newlineLen = System.getProperty("line.separator").length();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int count = 0;
        long atByte = 0L;
        int atLine = 1;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                REMatch match = pattern.getMatch(line);
                if ((options[8] && pattern.isMatch(line) || !options[8] && match != null) ^ options[6]) {
                    ++count;
                    if (!options[1]) {
                        if (options[3]) {
                            return true;
                        }
                        if (options[7]) {
                            if (filename != null) {
                                out.println(filename);
                            }
                            return true;
                        }
                        if (options[9]) {
                            return false;
                        }
                        if (filename != null) {
                            out.print(filename);
                            out.print(':');
                        }
                        if (options[2]) {
                            out.print(atLine);
                            out.print(':');
                        }
                        if (options[0]) {
                            out.print(atByte + (long)match.getStartIndex());
                            out.print(':');
                        }
                        out.println(line);
                    }
                }
                atByte += (long)(line.length() + newlineLen);
                ++atLine;
            }
            br.close();
            if (options[1]) {
                if (filename != null) {
                    out.println(filename + ':');
                }
                out.println(count);
            }
            if (options[9] && count == 0 && filename != null) {
                out.println(filename);
            }
        }
        catch (IOException e) {
            System.err.println("gnu.regexp.util.Grep: " + e);
        }
        return count > 0 ^ options[6];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

