
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.dir;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import java.io.*;

/**
 * JMichelle (Java Midori Shell) : path class
 */
public class MdShellDirFileFileSystem
	extends MdShellDirFileAbstract
{
	private MdShellEnv shellenv=null;
	private File fileMySelf=null;

	public MdShellDirFileFileSystem(MdShellEnv shellenv,File file)
	{
		this.shellenv=shellenv;
		this.fileMySelf=file;
		setType(FILE);

		try{
			setName(MdShellDirFactory.native2uri(fileMySelf.getCanonicalPath()));
		}catch(IOException ex){
			ex.printStackTrace();
		}

		setFileLength(fileMySelf.length());
		this.lastModified=fileMySelf.lastModified();
		bCanWrite=fileMySelf.canWrite();
		bCanRead=fileMySelf.canRead();
	}

	public String getShortName()
	{
		return MdShellDirFactory.getShortName(getName());
	}

	public MdShellDirDirectoryAbstract getPath()
	{
		//System.out.println("debug: 1: "+getName());
		if(new File(MdShellDirFactory.uri2native(getName())).isDirectory())
		{
			// As a matter of fact, it was a directory though it thought that 
			// this was file so far.
			return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(shellenv,getName(),true);
		}

		String strPathWithoutShortName=MdShellDirFactory.getPathWithoutShortName(getName());
		//System.out.println("debug: 2: "+strPathWithoutShortName);
		return (MdShellDirDirectoryAbstract)MdShellDirFactory.getInstance(shellenv,strPathWithoutShortName,true);
	}

	public void setLastModified(long lastModified)
	{
		this.lastModified=lastModified;
		fileMySelf.setLastModified(lastModified);
	}

	public final InputStream getInputStream()
	{
		try{
			return new FileInputStream(fileMySelf);
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
		return null;
	}

	public final OutputStream getOutputStream()
	{
		try{
			return new FileOutputStream(fileMySelf);
		}catch(IOException ex){
			System.out.println(ex.toString());
			ex.printStackTrace();
		}
		return null;
	}

	public boolean delete()
	{
		return fileMySelf.delete();
	}
}


