
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.cmd;

import gnu.regexp.*;
import gnu.regexp.util.*;

import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.dir.*;
import jp.ne.nifty.iga.midori.shell.io.*;
import jp.ne.nifty.iga.midori.shell.util.*;
import java.text.Collator;
import java.util.Vector;

public class MdShellCommandGrep
	extends MdShellCmdDefault
{
	public MdShellCommandGrep()
	{
		setCommand("grep");
		setDisplayString("GNU Regular Expressions for Java (gnu.regexp)");
	}

	public void processCommand(MdShellEnv shellenv)
	{
		String[] argvOrg=shellenv.getArgsArray();

		Vector vecArgsAfter=new Vector();

		String strFileNameWildCard=null;
		boolean isPatternFound=false;
		boolean isRecursive=false;
		for(int index=0;index<argvOrg.length;index++)
		{
			String strLook=argvOrg[index];
			if(strLook.startsWith("-"))
			{
				if(strLook.indexOf('r')!=(-1))
				{
					isRecursive=true;

					// erase r char for recursive option
					strLook=MdShellUtilString.eraseChar(strLook,'r');
				}

				if(strLook.length()>1)
				{
					vecArgsAfter.addElement(strLook);
				}
			}
			else
			{
				if(isPatternFound==false)
				{
					isPatternFound=true;
					vecArgsAfter.addElement(strLook);
				}
				else
				{
					strFileNameWildCard=MdShellUtilString.eraseChar(strLook,'*');
				}
			}
		}

		Vector vecList=null;
		if(strFileNameWildCard!=null)
		{
			if(isRecursive)
			{
				vecList=shellenv.getCurrentDirectory().listDirectoryWithSubDirectory(shellenv,MdShellDirNodeInfo.SELECT_FILE,strFileNameWildCard);
			}
			else
			{
				vecList=shellenv.getCurrentDirectory().listDirectory(shellenv,MdShellDirNodeInfo.SELECT_FILE,strFileNameWildCard);
			}
		}

		if(strFileNameWildCard==null)
		{
			Grep.grep(MdShellUtilString.vectorToStringarray(vecArgsAfter),RESyntax.RE_SYNTAX_GREP,shellenv.getOut());
		}
		else for(int index=0;index<vecList.size();index++)
		{
			MdShellDirNodeInterface dirLook=(MdShellDirNodeInterface)vecList.elementAt(index);
			Vector vecWrk=(Vector)vecArgsAfter.clone();
			vecWrk.addElement(MdShellDirFactory.uri2native(dirLook.getName()));
			Grep.grep(MdShellUtilString.vectorToStringarray(vecWrk),RESyntax.RE_SYNTAX_GREP,shellenv.getOut());
		}
	}
}


