/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package roomreservation.server;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import kandata.server.*;
import roomreservation.common.*;

/**
 * c\VXẽT[oAvP[V.
 * NCAg̗v󂯁AۂɃT[rXsĂ RoomReservation 
 * ĂяoĂ܂B
 */
public class RoomReservationServer implements Server {

	RoomReservation app;
	ServerContext serverContext;
	String classPath = "";

	/**
	 *
	 */
	public void init(ServerContext serverContext) {
		System.out.println("RoomReservationServer.init()");
		this.serverContext = serverContext;

		app = new RoomReservation(serverContext);
		try {
			app.init();
		} catch (Exception e) {}
	}
	
	public Object invoke(ClientContext context, String command, Object[] args) {
		//super.invoke(session, method_name, args);
		System.out.println("RoomReservationServer.invoke("+context+", "+command+", args )");
		if (command.equals("getRoomList")) {
			return app.getRoomList();
		}
		else if (command.equals("getReservationList")) {
			return app.getReservationList((String) args[0]);
		}
		else if (command.equals("registReservation")) {
			boolean rc = app.registReservation((Reservation) args[0]);
			return new Boolean(rc);
		}
		else if (command.equals("cancelReservation")) {
			app.cancelReservation((Reservation) args[0]);
			return null;
		}
		else {
			System.out.println("`ĂȂR}hł :"+command);
		}
		return null;
	}
	public void connected(ClientContext context) {
	}
	public void disconnected(ClientContext context) {
	}
	public void exit() {
		app.exit();
	}
	
}


