/**
* Kandata
* Copyright (C) 2003. Yoshinori Watanabe
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package kandata.server;

import java.util.HashMap;

/**
 * T[oǗANCAgƂ̃ReLXg.
 */
public class ClientContext {

	/** NCAgID𐶐邽߂̎. */
	private static int idSeed = 0;

	/** NCAgID. */
	private final String id;	// ɂݒłȂ

	/** ڑꂽ. */
	private long connectTimeMillis;

	/** ŌɃANZX. */
	private long lastAccessTimeMillis;

	/** NCAgReLXg𐶐܂. */
	public ClientContext(long millis) {
		id = "" + idSeed;
		idSeed++;
		connectTimeMillis = lastAccessTimeMillis = millis;
	}
	/** NCAgIDԂ܂. */
	public String getId() { return id; }

	/** ŏIANZXXV܂. */
	public void setLastAccessTimeMillis(long millis) {
		lastAccessTimeMillis = millis;
	}
	/** ŏIANZX擾܂. */
	public long getLastAccessTimeMillis() {
		return lastAccessTimeMillis;
	}
	/** ڑ擾܂. */
	public long getConnectTimeMillis() {
		return connectTimeMillis;
	}

	/** AvP[Vp̃vpeB */
	private HashMap applicationProperties = new HashMap();

	/** AvP[Vp\ȃvpeB擾܂. */
	public Object getApplicationProperty(Object key) {
		return applicationProperties.get(key);
	}
	/** AvP[Vp\ȃvpeBݒ肵܂. */
	public void setApplicationProperty(Object key, Object value) {
		applicationProperties.put(key ,value);
	}
	/** AvP[Vp\ȃvpeB폜܂. */
	public Object removeApplicationProperty(Object key) {
		return applicationProperties.remove(key);
	}
	/** AvP[Vp\ȃvpeBׂč폜܂. */
	public void clearApplicationProperty() {
		applicationProperties.clear();
	}
	/** AvP[Vp\ȃvpeBׂč폜܂. */
	public int getApplicationPropertySize() {
		return applicationProperties.size();
	}
}
/*
	AvP[VvpeBWebAvɔׂāAp@͏Ȃ悤ȋCB
*/
