
/**
 * JMichelle (Java Midori Shell)
 * Copyright (C) 2000 Midori IGA 
 *   (http://www01.u-page.so-net.ne.jp/db3/midori/midosoft.html)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package jp.ne.nifty.iga.midori.shell.io;

import jp.ne.nifty.iga.midori.shell.MdShellDef;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * JMichelle (Java Midori Shell) : 
 */
public class MdShellFtpcOutputStream
	extends OutputStream
{
	MdShellFtpc ftpc=null;
	private OutputStream outStream=null;

	public MdShellFtpcOutputStream(MdShellFtpc ftpc,OutputStream outStream)
	{
		this.ftpc=ftpc;
		this.outStream=outStream;
	}

	public final void write(int bArg) throws IOException
	{
		//if(MdShellDef.IS_DEBUG)System.out.println("MdShellFtpcOutputStream.write()");
		outStream.write(bArg);
	}

	public final void flush() throws IOException
	{
		if(MdShellDef.IS_DEBUG)System.out.println("MdShellFtpcOutputStream.flush()");
		outStream.flush();
	}

	public final void close() throws IOException
	{
		if(MdShellDef.IS_DEBUG)System.out.println("MdShellFtpcOutputStream.close()");
		if(ftpc.closeDataSocketStream()==false)
		{
			System.out.println("ftp write is failed.");
		}
	}


}


