/*
 * Decompiled with CFR 0.152.
 */
package kandata.server.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kandata.server.ClientContext;
import kandata.server.Server;
import kandata.server.ServerContext;

public class ServletServer
extends HttpServlet
implements ServerContext {
    static final boolean TRACE_ENABLE = true;
    private static final String CONFIG_FILENAME = "kandata.properties";
    protected Server server;
    protected String serverClassName;
    protected String serverResourcePath;
    protected String clientEntryClassName;
    protected String clientClassPath;
    protected String clientResourcePath;
    private HashMap clientContextMap = new HashMap();

    static final void TRACE(String message) {
        System.out.println(message);
    }

    static final void TRACE(Throwable ex) {
        ex.printStackTrace(System.out);
    }

    public void init() throws ServletException {
        ServletServer.TRACE("<<< init() >>>");
        super.init();
        this.loadConfiguration(CONFIG_FILENAME);
        try {
            this.server = (Server)Class.forName(this.serverClassName).newInstance();
        }
        catch (Exception e) {
            ServletServer.TRACE(e);
        }
        this.server.init(this);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Object ret;
            long now = System.currentTimeMillis();
            ObjectInputStream in = new ObjectInputStream((InputStream)request.getInputStream());
            String id = (String)in.readObject();
            String command = (String)in.readObject();
            int args_len = in.readInt();
            ServletServer.TRACE("  ID=" + id + " command=[" + command + "] args_len=" + args_len + " -------------------");
            Object[] args = new Object[args_len];
            for (int i = 0; i < args_len; ++i) {
                args[i] = in.readObject();
                ServletServer.TRACE("  args[" + i + "]=" + args[i]);
            }
            in.close();
            ClientContext context = (ClientContext)this.clientContextMap.get(id);
            if (command.charAt(0) == '@') {
                if (command.equals("@connect")) {
                    context = new ClientContext(now);
                    this.clientContextMap.put(context.getId(), context);
                }
                ret = this.invokeSystemCommand(context, command, args);
                if (command.equals("@disconnect")) {
                    this.clientContextMap.remove(id);
                }
            } else {
                ret = this.server.invoke(context, command, args);
            }
            ServletServer.TRACE("  ret=" + ret);
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
            out.writeObject(ret);
            out.close();
            context.setLastAccessTimeMillis(now);
        }
        catch (Exception e) {
            ServletServer.TRACE(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object invokeSystemCommand(ClientContext context, String command, Object[] args) {
        if (command.equals("@getClass")) {
            byte[] byArray;
            FileInputStream in;
            block24: {
                String classname = (String)args[0];
                String path = this.getWebInfPath() + File.separator + this.clientClassPath + File.separator + classname.replace('.', File.separatorChar) + ".class";
                ServletServer.TRACE("path=" + path);
                in = null;
                File file = new File(path);
                byte[] buf = new byte[(int)file.length()];
                in = new FileInputStream(file);
                in.read(buf, 0, (int)file.length());
                byArray = buf;
                Object var11_19 = null;
                if (in == null) break block24;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return byArray;
            catch (IOException e) {
                Object var8_16;
                block25: {
                    try {
                        ServletServer.TRACE(e);
                        var8_16 = null;
                        Object var11_20 = null;
                        if (in == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object var11_21 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return var8_16;
            }
        }
        if (command.equals("@getResource")) {
            byte[] byArray;
            FileInputStream in;
            block26: {
                String path = this.getWebInfPath() + File.separator + this.clientResourcePath + (String)args[0];
                ServletServer.TRACE("path=" + path);
                in = null;
                File file = new File(path);
                byte[] buf = new byte[(int)file.length()];
                in = new FileInputStream(file);
                in.read(buf, 0, (int)file.length());
                byArray = buf;
                Object var14_26 = null;
                if (in == null) break block26;
                try {
                    in.close();
                }
                catch (IOException e3) {
                    // empty catch block
                }
            }
            return byArray;
            catch (IOException e) {
                Object var7_14;
                block27: {
                    try {
                        ServletServer.TRACE(e);
                        var7_14 = null;
                        Object var14_27 = null;
                        if (in == null) break block27;
                    }
                    catch (Throwable throwable) {
                        Object var14_28 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e3) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                }
                return var7_14;
            }
        }
        if (command.equals("@connect")) {
            this.server.connected(context);
            return context.getId();
        }
        if (command.equals("@disconnect")) {
            this.server.disconnected(context);
        } else {
            if (command.equals("@getEntryClassName")) {
                return this.clientEntryClassName;
            }
            ServletServer.TRACE("unknown command=" + command);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadConfiguration(String fname) {
        FileInputStream in = null;
        in = new FileInputStream(this.getWebInfPath() + File.separator + fname);
        Properties prop = new Properties();
        prop.load(in);
        String appname = prop.getProperty("application.name");
        this.serverClassName = prop.getProperty("application.serverclassname");
        this.serverResourcePath = prop.getProperty("application.serverresourcepath");
        this.clientEntryClassName = prop.getProperty("application.cliententryclassname");
        this.clientClassPath = prop.getProperty("application.clientclasspath");
        this.clientResourcePath = prop.getProperty("application.clientresourcepath");
        in.close();
        ServletServer.TRACE("application.name=" + appname);
        ServletServer.TRACE("application.serverclassname=" + this.serverClassName);
        ServletServer.TRACE("application.serverresourcepath=" + this.serverResourcePath);
        ServletServer.TRACE("application.cliententryclassname=" + this.clientEntryClassName);
        ServletServer.TRACE("application.clientclasspath=" + this.clientClassPath);
        ServletServer.TRACE("application.clientresourcepath=" + this.clientResourcePath);
        Object var6_6 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                ServletServer.TRACE(e);
                Object var6_7 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void destroy() {
        this.server.exit();
    }

    public String getResourcePath() {
        return this.getWebInfPath() + File.separator + this.serverResourcePath;
    }

    private String getWebInfPath() {
        return this.getServletContext().getRealPath("/WEB-INF");
    }
}

