/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.eng;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdAlias;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandBase64;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandCat;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandCodeConv;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandDir;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandEdit;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandGrep;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandHelp;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandInterface;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandMcd;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandMemo;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandMmake;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandPwd;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandSelect;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCommandSplit;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellException;

public class MdShellCmdList {
    public static final String[][] straryCommandList = new String[][]{{"exec", "invoke module"}, {"exit", "exit                   , quit is alias"}, {"history", "show command history   , ! is alias"}, {"menu", "show menu"}, {"quit", "exit"}};
    private Vector vecImplementedCommandElementList = new Vector(128);

    public MdShellCmdList() {
        this.init();
    }

    private void init() {
        for (int index = 0; index < straryCommandList.length; ++index) {
            String[] straryLook = straryCommandList[index];
            this.addImplementedCommand(new MdShellCmdAlias(straryLook[0], straryLook[1]));
        }
        this.addImplementedCommand(new MdShellCommandBase64());
        this.addImplementedCommand(new MdShellCommandCat());
        this.addImplementedCommand(new MdShellCommandCodeConv());
        this.addImplementedCommand(new MdShellCommandDir());
        this.addImplementedCommand(new MdShellCommandEdit());
        this.addImplementedCommand(new MdShellCommandGrep());
        this.addImplementedCommand(new MdShellCommandHelp());
        this.addImplementedCommand(new MdShellCommandMcd());
        this.addImplementedCommand(new MdShellCommandMemo());
        this.addImplementedCommand(new MdShellCommandMmake());
        this.addImplementedCommand(new MdShellCommandPwd());
        this.addImplementedCommand(new MdShellCommandSelect());
        this.addImplementedCommand(new MdShellCommandSplit());
        this.initFromFile();
        this.sortImplementedCommand();
    }

    private void initFromFile() {
        try {
            String strRead;
            File fileLoad = new File("MdShellCmd.def");
            if (!fileLoad.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fileLoad));
            while ((strRead = reader.readLine()) != null) {
                StringTokenizer toknizerTab = new StringTokenizer(strRead, "\t\n", false);
                String strCommand = null;
                String strDisplayString = null;
                String strPathName = null;
                try {
                    strCommand = toknizerTab.nextToken();
                    strDisplayString = toknizerTab.nextToken();
                    strPathName = toknizerTab.nextToken();
                }
                catch (NoSuchElementException ex) {
                    // empty catch block
                }
                if (strCommand == null) continue;
                if (strCommand.equals("edit")) {
                    strCommand = "$" + strCommand;
                }
                this.addImplementedCommand(new MdShellCmdAlias(strCommand, strDisplayString, strPathName));
            }
            reader.close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
    }

    private void sortImplementedCommand() {
        Comparator cmparetorMdShellCommandInterface = new Comparator(){

            public int compare(Object o1, Object o2) {
                MdShellCommandInterface f1 = (MdShellCommandInterface)o1;
                MdShellCommandInterface f2 = (MdShellCommandInterface)o2;
                return f1.getCommand().compareTo(f2.getCommand());
            }
        };
        Collections.sort(this.vecImplementedCommandElementList, cmparetorMdShellCommandInterface);
    }

    private void addImplementedCommand(MdShellCommandInterface cmdelement) {
        this.vecImplementedCommandElementList.addElement(cmdelement);
    }

    public Vector getImplementedCommandList() {
        Vector vecRet = new Vector(128);
        for (int index = 0; index < this.vecImplementedCommandElementList.size(); ++index) {
            MdShellCommandInterface cmdelement = (MdShellCommandInterface)this.vecImplementedCommandElementList.elementAt(index);
            cmdelement.registerImplementedCommand(vecRet);
        }
        return vecRet;
    }

    public String getImplementedCommandListForDisplayString() {
        StringBuffer strbuf = new StringBuffer();
        for (int index = 0; index < this.vecImplementedCommandElementList.size(); ++index) {
            MdShellCommandInterface cmdelementLook = (MdShellCommandInterface)this.vecImplementedCommandElementList.elementAt(index);
            if (cmdelementLook.getCommand().charAt(0) == '$') continue;
            strbuf.append(" ");
            strbuf.append(cmdelementLook.getHelpString());
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    private Vector getMenuFilterList() {
        Vector<String> vecList = new Vector<String>(128);
        try {
            String strRead;
            File fileLoad = new File("MdShellMenu.def");
            if (!fileLoad.exists()) {
                return vecList;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fileLoad));
            while ((strRead = reader.readLine()) != null) {
                vecList.addElement(strRead);
            }
            reader.close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
        return vecList;
    }

    public Vector getFilteredCommandList() {
        Vector<String> vecMenuCommand = new Vector<String>(128);
        block0: for (int index = 0; index < this.vecImplementedCommandElementList.size(); ++index) {
            MdShellCommandInterface cmdelementLook = (MdShellCommandInterface)this.vecImplementedCommandElementList.elementAt(index);
            String strCommand = cmdelementLook.getCommand();
            for (int indexInner = 0; indexInner < this.getMenuFilterList().size(); ++indexInner) {
                String strCompare = (String)this.getMenuFilterList().elementAt(indexInner);
                if (!strCommand.equals(strCompare)) continue;
                vecMenuCommand.addElement(strCommand);
                continue block0;
            }
        }
        return vecMenuCommand;
    }

    public Vector getFilteredCommandListForDisplay() {
        Vector<String> vecMenuCommand = new Vector<String>(128);
        block0: for (int index = 0; index < this.vecImplementedCommandElementList.size(); ++index) {
            MdShellCommandInterface cmdelementLook = (MdShellCommandInterface)this.vecImplementedCommandElementList.elementAt(index);
            String strCommand = cmdelementLook.getCommand();
            for (int indexInner = 0; indexInner < this.getMenuFilterList().size(); ++indexInner) {
                String strCompare = (String)this.getMenuFilterList().elementAt(indexInner);
                if (!strCommand.equals(strCompare)) continue;
                vecMenuCommand.addElement(cmdelementLook.getHelpString());
                continue block0;
            }
        }
        return vecMenuCommand;
    }

    public boolean processCommand(MdShellEnv shellenv, String strCommand) throws MdShellException {
        for (int index = 0; index < this.vecImplementedCommandElementList.size(); ++index) {
            MdShellCommandInterface cmdelementLook = (MdShellCommandInterface)this.vecImplementedCommandElementList.elementAt(index);
            if (!cmdelementLook.isThisCommand(shellenv, strCommand)) continue;
            cmdelementLook.processCommand(shellenv);
            return true;
        }
        return false;
    }

    public String getFullPathNameByCommand(String strCommand) {
        for (int index = 0; index < this.vecImplementedCommandElementList.size(); ++index) {
            MdShellCommandInterface cmdelementLook = (MdShellCommandInterface)this.vecImplementedCommandElementList.elementAt(index);
            if (!strCommand.equals(cmdelementLook.getCommand())) continue;
            if (cmdelementLook instanceof MdShellCmdAlias) {
                MdShellCmdAlias cmdDef = (MdShellCmdAlias)cmdelementLook;
                return cmdDef.getFullPathName();
            }
            return null;
        }
        return null;
    }
}

