/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.dir;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.FtpFileNodeInfo;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryRoot;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileFtpClient;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInfo;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFileNameComparator;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFtpServerNode;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.io.MdShellFtpc;

public class MdShellDirDirectoryFtpClient
extends MdShellDirDirectoryAbstract {
    private String strUsername;
    private String strPassword;
    private boolean isStartDirectory = false;
    private MdShellEnv shellenv = null;
    public static final String DEFAULT_ENCODE = "EUC_JP";
    public String strEncode = null;
    private boolean isOpened = false;

    public MdShellDirDirectoryFtpClient(MdShellEnv shellenv, String strUri) {
        this.shellenv = shellenv;
        this.init();
        this.setType(2);
        MdShellFtpServerNode ftpservernode = (MdShellFtpServerNode)shellenv.getFtpServerList().get(SZ_PROTOCOL[this.getType()] + MdShellDirFactory.getHostName(strUri));
        this.strUsername = ftpservernode.strUser;
        this.strPassword = ftpservernode.strPassword;
        if (MdShellDirFactory.getDirectory(strUri, true).equals("/.")) {
            this.isStartDirectory = true;
        }
        this.setName(strUri);
    }

    private void init() {
        try {
            "TEST".getBytes(DEFAULT_ENCODE);
            this.strEncode = DEFAULT_ENCODE;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void ensureOpen() {
        MdShellFtpc ftpc;
        if (this.isOpened) {
            return;
        }
        if (this.getName().endsWith("/.") && (ftpc = MdShellFtpc.getInstance(this.shellenv, this.getName())) != null) {
            this.setName(this.getName().substring(0, this.getName().length() - 2) + ftpc.pwd());
        }
        this.setFileLength(0L);
        this.lastModified = 0L;
        this.bCanWrite = true;
        this.bCanRead = true;
        this.isOpened = true;
    }

    public String getShortName() {
        if (this.isStartDirectory) {
            return MdShellDirFactory.getHostName(this.getName());
        }
        int iFind = this.getName().lastIndexOf(47);
        if (iFind >= 0) {
            return this.getName().substring(this.getName().lastIndexOf(47) + 1);
        }
        return this.getName();
    }

    public MdShellDirDirectoryAbstract getParentDirectory() {
        this.ensureOpen();
        String strSeparator = "/";
        String strCurrentDirectory = this.getName();
        if (strCurrentDirectory.lastIndexOf(47) <= SZ_PROTOCOL[this.getType()].length()) {
            return new MdShellDirDirectoryRoot();
        }
        strCurrentDirectory = strCurrentDirectory.substring(0, strCurrentDirectory.lastIndexOf(47));
        MdShellDirDirectoryFtpClient filesystemnode = new MdShellDirDirectoryFtpClient(this.shellenv, strCurrentDirectory);
        return filesystemnode;
    }

    public MdShellDirDirectoryAbstract getChildDirectory(String strSubDirectory) {
        this.ensureOpen();
        String strSeparator = "/";
        String strCurrentDirectory = this.getName();
        String strFullPathDirectory = null;
        strFullPathDirectory = strCurrentDirectory.endsWith(strSeparator) ? strCurrentDirectory + strSubDirectory : strCurrentDirectory + strSeparator + strSubDirectory;
        MdShellDirDirectoryFtpClient filesystemnode = new MdShellDirDirectoryFtpClient(this.shellenv, strFullPathDirectory);
        return filesystemnode;
    }

    public boolean isDirectoryExist() {
        this.ensureOpen();
        return true;
    }

    public Vector listDirectory(MdShellEnv shellenv, int iSelect, String strRe) {
        this.ensureOpen();
        Vector<MdShellDirNodeInfo> vecList = new Vector<MdShellDirNodeInfo>(1024);
        MdShellFtpc ftpc = MdShellFtpc.getInstance(shellenv, this.getName());
        if (ftpc == null) {
            return vecList;
        }
        if (!ftpc.cd(MdShellDirFactory.getDirectory(this.getName(), true))) {
            shellenv.getOut().println("change directory is failed: " + MdShellDirFactory.getDirectory(this.getName(), true));
            return vecList;
        }
        try {
            String strRead;
            byte[] byteList = ftpc.ls();
            InputStreamReader inputstreamReader = null;
            inputstreamReader = this.strEncode == null ? new InputStreamReader(new ByteArrayInputStream(byteList)) : new InputStreamReader((InputStream)new ByteArrayInputStream(byteList), this.strEncode);
            BufferedReader reader = new BufferedReader(inputstreamReader);
            while ((strRead = reader.readLine()) != null) {
                MdShellDirNodeInfo look;
                String strUri;
                FtpFileNodeInfo nodeInfo;
                String strSeparator = "/";
                if (strRead.length() <= 10 || (nodeInfo = this.buildFileNameFromLsResult(strRead)) == null) continue;
                if (nodeInfo.strPermission.charAt(0) == 'd') {
                    if (nodeInfo.strFileName == null || iSelect != 1 && iSelect != 2) continue;
                    strUri = this.getName();
                    if (strUri.endsWith("/.")) {
                        strUri = strUri.substring(0, strUri.length() - 2);
                    } else if (strUri.endsWith("/")) {
                        strUri = strUri.substring(0, strUri.length() - 1);
                    }
                    look = new MdShellDirDirectoryFtpClient(shellenv, strUri + strSeparator + nodeInfo.strFileName);
                    look.setFileLength(nodeInfo.lFileSize);
                    ((MdShellDirDirectoryFtpClient)look).lastModified = nodeInfo.lLastModified;
                    if (!MdShellDirDirectoryFtpClient.isReMatch(strRe, ((MdShellDirDirectoryFtpClient)look).getShortName())) continue;
                    vecList.addElement(look);
                    continue;
                }
                if (nodeInfo.strPermission.charAt(0) != '-' || nodeInfo.strFileName == null || iSelect != 1 && iSelect != 3) continue;
                strUri = this.getName();
                if (strUri.endsWith("/.")) {
                    strUri = strUri.substring(0, strUri.length() - 2);
                } else if (strUri.endsWith("/")) {
                    strUri = strUri.substring(0, strUri.length() - 1);
                }
                look = (MdShellDirFileFtpClient)MdShellDirFactory.getInstance(shellenv, strUri + strSeparator + nodeInfo.strFileName, false);
                look.setFileLength(nodeInfo.lFileSize);
                ((MdShellDirFileFtpClient)look).lastModified = nodeInfo.lLastModified;
                if (!MdShellDirDirectoryFtpClient.isReMatch(strRe, ((MdShellDirFileFtpClient)look).getShortName())) continue;
                vecList.addElement(look);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
        }
        Collections.sort(vecList, new MdShellFileNameComparator(MdShellDirDirectoryFtpClient.getCollatorInstance()));
        return vecList;
    }

    private FtpFileNodeInfo buildFileNameFromLsResult(String strReadLine) {
        this.ensureOpen();
        StringTokenizer toknizerTab = new StringTokenizer(strReadLine, " ", false);
        try {
            FtpFileNodeInfo nodeInfo = new FtpFileNodeInfo();
            nodeInfo.strPermission = toknizerTab.nextToken();
            if (!nodeInfo.strPermission.startsWith("d") && !nodeInfo.strPermission.startsWith("-")) {
                nodeInfo.strPermission = toknizerTab.nextToken();
                if (!nodeInfo.strPermission.startsWith("d") && !nodeInfo.strPermission.startsWith("-")) {
                    return null;
                }
            }
            Vector<String> vecRead = new Vector<String>();
            try {
                while (true) {
                    vecRead.addElement(toknizerTab.nextToken());
                }
            }
            catch (NoSuchElementException ex) {
                String strFileMonth = null;
                String strFileDate = null;
                String strFileTime = null;
                if (vecRead.size() == 8) {
                    nodeInfo.lFileSize = Integer.parseInt((String)vecRead.elementAt(3));
                    strFileMonth = (String)vecRead.elementAt(4);
                    strFileDate = (String)vecRead.elementAt(5);
                    strFileTime = (String)vecRead.elementAt(6);
                    nodeInfo.strFileName = (String)vecRead.elementAt(7);
                } else if (vecRead.size() == 7) {
                    nodeInfo.lFileSize = Integer.parseInt((String)vecRead.elementAt(2));
                    strFileMonth = (String)vecRead.elementAt(3);
                    strFileDate = (String)vecRead.elementAt(4);
                    strFileTime = (String)vecRead.elementAt(5);
                    nodeInfo.strFileName = (String)vecRead.elementAt(6);
                } else {
                    this.shellenv.getOut().println("directory or file line [" + strReadLine + "] is ignored.");
                    return null;
                }
                String strYear = "" + Calendar.getInstance().get(1);
                if (strFileTime.indexOf(58) < 0) {
                    strYear = strFileTime;
                    strFileTime = "00:00";
                }
                String[] straryMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                for (int index = 0; index < straryMonth.length; ++index) {
                    if (!strFileMonth.equals(straryMonth[index])) continue;
                    strFileMonth = "" + (index + 1);
                }
                strFileMonth = strFileMonth.replace('\u6708', ' ').trim();
                strFileDate = strFileDate.replace('\u65e5', ' ').trim();
                if (strYear.indexOf(24180) > 0) {
                    strYear = strYear.replace('\u5e74', ' ').trim();
                }
                String strDateTime = strYear + "/" + strFileMonth + "/" + strFileDate + " " + strFileTime;
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    Date timeCheck = simpleDateFormat.parse(strDateTime);
                    nodeInfo.lLastModified = timeCheck.getTime();
                }
                catch (ParseException ex2) {
                    // empty catch block
                }
                return nodeInfo;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public boolean delete() {
        return false;
    }
}

