/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdDefault;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInterface;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellDirLongListFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellDirectoryNameFormatter;
import jp.ne.nifty.iga.midori.shell.io.MdShellUtilExec;
import jp.ne.nifty.iga.midori.shell.util.MdShellNativeToAscii;
import jp.ne.nifty.iga.midori.shell.util.cat.Cat;
import jp.ne.nifty.iga.midori.shell.util.dir.Dir;
import jp.ne.nifty.iga.midori.shell.util.mcd.Mcd;

public class MdShellCommandSelect
extends MdShellCmdDefault {
    public MdShellCommandSelect() {
        this.setCommand("select");
        this.setDisplayString("select file or directory");
    }

    public void processCommand(MdShellEnv shellenv) throws MdShellCancelException {
        shellenv.getOut().println("under construction.");
        Vector<String> vecList = new Vector<String>();
        vecList.addElement("file");
        vecList.addElement("directory");
        vecList.addElement("group");
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select what to select: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strSubCommand = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strSubCommand == null) {
            throw new MdShellCancelException();
        }
        if (strSubCommand.equals("file")) {
            this.selectFile(shellenv);
        } else if (strSubCommand.equals("directory")) {
            this.selectDirectoryImpl(shellenv);
        } else if (strSubCommand.equals("group")) {
            shellenv.getOut().println("not implemented.");
        }
    }

    public void selectFile(MdShellEnv shellenv) throws MdShellCancelException {
        shellenv.getOut().print("input option if exist. (ex. -Rt *.java): ");
        shellenv.promptInputIfNoDataExist();
        String[] strArgs = shellenv.getArgsArray();
        Dir dirWrk = new Dir();
        Vector vecList = dirWrk.buildData(shellenv, strArgs);
        MdShellDirLongListFormatter formatter = new MdShellDirLongListFormatter();
        if (vecList.size() == 0) {
            shellenv.getOut().println("no file is selected");
            return;
        }
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, formatter);
        shellenv.getOut().print("select file (or input all): ");
        String strSelectOneOrAll = shellenv.getNextLine();
        if (strSelectOneOrAll == null) {
            throw new MdShellCancelException();
        }
        MdShellDirNodeInterface dirNodeInterface = null;
        if (strSelectOneOrAll.equals("all")) {
            shellenv.getOut().println("all command not implemented.");
            return;
        }
        dirNodeInterface = (MdShellDirNodeInterface)MdShellListSelection.selectFromList(shellenv, vecList, new MdShellDirectoryNameFormatter(), strSelectOneOrAll);
        if (dirNodeInterface != null) {
            this.selectProcess(shellenv, dirNodeInterface);
        }
    }

    public void selectDirectoryImpl(MdShellEnv shellenv) throws MdShellCancelException {
        shellenv.getOut().println("select source directory.");
        MdShellDirDirectoryAbstract dirSourceDirectory = Mcd.selectDirectoryContinuous(shellenv, shellenv.getCurrentDirectory());
        if (dirSourceDirectory == null) {
            throw new MdShellCancelException();
        }
        Vector<String> vecList = new Vector<String>();
        vecList.addElement("copy");
        vecList.addElement("delete");
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select what to do: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strSubCommand = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strSubCommand == null) {
            throw new MdShellCancelException();
        }
        if (strSubCommand.equals("copy")) {
            shellenv.getOut().println("select target directory.");
            MdShellDirDirectoryAbstract dirTargetDirectory = Mcd.selectDirectoryContinuous(shellenv, shellenv.getCurrentDirectory());
            if (dirTargetDirectory == null) {
                throw new MdShellCancelException();
            }
            shellenv.getOut().println("start to copy plan.");
            shellenv.getOut().println("copy " + dirSourceDirectory.getName() + " -> " + dirTargetDirectory.getName());
        }
        shellenv.getOut().println("not implemented.");
    }

    public void selectProcess(MdShellEnv shellenv, MdShellDirNodeInterface dirNodeInterface) throws MdShellCancelException {
        Vector<String> vecList = new Vector<String>();
        vecList.addElement("copy");
        vecList.addElement("delete");
        vecList.addElement("edit");
        if (shellenv.getCommandList().getFullPathNameByCommand("wedit") != null && (dirNodeInterface.getName().endsWith("html") || dirNodeInterface.getName().endsWith("htm"))) {
            vecList.addElement("wedit");
        }
        vecList.addElement("cat");
        vecList.addElement("n2a");
        vecList.addElement("a2n");
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select what to do: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strSubCommand = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strSubCommand == null) {
            throw new MdShellCancelException();
        }
        if (strSubCommand.equals("copy")) {
            shellenv.getOut().println("select target directory.");
            MdShellDirDirectoryAbstract dirTargetDirectory = Mcd.selectDirectoryContinuous(shellenv, shellenv.getCurrentDirectory());
            if (dirTargetDirectory != null) {
                shellenv.getOut().println("start to copy plan.");
                String strBaseDirectory = shellenv.getCurrentDirectory().getName();
                shellenv.getOut().println("base directory: " + strBaseDirectory);
                shellenv.getOut().println("copy " + dirNodeInterface.getName().substring(strBaseDirectory.length() + 1) + " -> " + dirTargetDirectory.getName());
            }
        } else {
            if (strSubCommand.equals("delete")) {
                shellenv.getOut().println("start to delete.");
                dirNodeInterface.delete();
                return;
            }
            if (strSubCommand.equals("edit")) {
                shellenv.getOut().println("edit file");
                MdShellUtilExec.exec(shellenv, shellenv.getCommandList().getFullPathNameByCommand("$edit") + " " + MdShellDirFactory.quoteFileNameWhenSpaceIsExist(MdShellDirFactory.uri2native(dirNodeInterface.getName())) + "&");
                shellenv.getFileHistory().addElement(MdShellDirFactory.uri2native(dirNodeInterface.getName()));
                return;
            }
            if (strSubCommand.equals("wedit")) {
                shellenv.getOut().println("edit web file");
                MdShellUtilExec.exec(shellenv, shellenv.getCommandList().getFullPathNameByCommand("wedit").replace('&', ' ') + " " + MdShellDirFactory.quoteFileNameWhenSpaceIsExist(MdShellDirFactory.uri2native(dirNodeInterface.getName())) + "&");
                shellenv.getFileHistory().addElement(MdShellDirFactory.uri2native(dirNodeInterface.getName()));
                return;
            }
            if (strSubCommand.equals("cat")) {
                Cat catWrk = new Cat();
                catWrk.cat(shellenv, (MdShellDirFileAbstract)dirNodeInterface);
                return;
            }
            if (strSubCommand.equals("n2a")) {
                try {
                    MdShellDirFileAbstract dirfileOutput = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, dirNodeInterface.getName() + ".ascii.temp", false);
                    InputStream inStream = ((MdShellDirFileAbstract)dirNodeInterface).getInputStream();
                    OutputStream outStream = dirfileOutput.getOutputStream();
                    MdShellNativeToAscii.native2ascii(inStream, outStream);
                    inStream.close();
                    outStream.flush();
                    outStream.close();
                    dirfileOutput.setLastModified(dirNodeInterface.getLastModified());
                }
                catch (IOException ex) {
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
                return;
            }
            if (strSubCommand.equals("a2n")) {
                try {
                    MdShellDirFileAbstract dirfileOutput = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, dirNodeInterface.getName() + ".native.temp", false);
                    InputStream inStream = ((MdShellDirFileAbstract)dirNodeInterface).getInputStream();
                    OutputStream outStream = dirfileOutput.getOutputStream();
                    MdShellNativeToAscii.ascii2native(inStream, outStream);
                    inStream.close();
                    outStream.flush();
                    outStream.close();
                    dirfileOutput.setLastModified(dirNodeInterface.getLastModified());
                }
                catch (IOException ex) {
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
                return;
            }
        }
        shellenv.getOut().println("not implemented.[" + strSubCommand + "]");
    }
}

