package org.maachang.dbm.engine ;

/**
 * MDbm監視用スレッド.
 * 
 * @version 2008/01/17
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public class MDbmThread extends Thread {
    
    /**
     * データ更新タイミング.
     * 15sec.
     */
    private static final long TIMING = 15000L ;
    
    /**
     * MDbmエンジン.
     */
    private MDbmEngine engine = null ;
    
    /**
     * データ更新実行時間.
     */
    private long timing = -1L ;
    
    /**
     * 停止フラグ.
     */
    private volatile boolean stopFlag = false ;
    
    /**
     * 同期オブジェクト.
     */
    private final Object sync = new Object() ;
    
    /**
     * コンストラクタ.
     */
    private MDbmThread() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を設定してオブジェクトを生成します.
     * <BR>
     * @param engine MDbmエンジンを設定します.
     */
    public MDbmThread( MDbmEngine engine ) {
        this.engine = engine ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    /**
     * デストラクタ.
     * <BR>
     * @exception Exception 例外.
     */
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() {
        setStop( true ) ;
        engine = null ;
        timing = -1L ;
    }
    
    /**
     * 更新タイミングを設定.
     * <BR><BR>
     * 更新タイミングを設定します.
     */
    public void setTiming() {
        synchronized( sync ) {
            timing = System.currentTimeMillis() ;
        }
    }
    
    /**
     * 更新タイミングを停止.
     * <BR><BR>
     * 更新タイミングを停止します.
     */
    public void destroyTiming() {
        synchronized( sync ) {
            timing = -1L ;
        }
    }
    
    /**
     * スレッド停止チェック.
     * <BR><BR>
     * スレッド停止チェックを行います.
     * <BR>
     * @return boolean [true]の場合、停止しています.
     */
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    private static final long WAIT_TIME = 500 ;
    
    /**
     * スレッド実行.
     */
    public void run() {
        ThreadDeath threadDeach = null ;
        boolean endFlag = false ;
        for( ;; ) {
            try {
                Thread.sleep( WAIT_TIME ) ;
                if( endFlag == true || isStop() == true ) {
                    endFlag = true ;
                    break ;
                }
                long t ;
                synchronized( sync ) {
                    t = timing ;
                }
                if( t <= -1L ) {
                    continue ;
                }
                if( t + TIMING <= System.currentTimeMillis() ) {
                    synchronized( sync ) {
                        timing = -1L ;
                    }
                    engine.flush() ;
                }
            } catch( InterruptedException ie ) {
                endFlag = true ;
            } catch ( NullPointerException ne ) {
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
}
