/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.maachang.dbm.engine.MDbmEngine;

public class MDbmThread
extends Thread {
    private static final long TIMING = 15000L;
    private MDbmEngine engine = null;
    private long timing = -1L;
    private volatile boolean stopFlag = false;
    private final Object sync = new Object();
    private static final long WAIT_TIME = 500L;

    private MDbmThread() {
    }

    public MDbmThread(MDbmEngine engine) {
        this.engine = engine;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.setStop(true);
        this.engine = null;
        this.timing = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTiming() {
        Object object = this.sync;
        synchronized (object) {
            this.timing = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyTiming() {
        Object object = this.sync;
        synchronized (object) {
            this.timing = -1L;
        }
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadDeath threadDeach = null;
        boolean endFlag = false;
        while (true) {
            try {
                long t;
                Thread.sleep(500L);
                if (endFlag || this.isStop()) {
                    endFlag = true;
                    break;
                }
                Object object = this.sync;
                synchronized (object) {
                    t = this.timing;
                }
                if (t <= -1L || t + 15000L > System.currentTimeMillis()) continue;
                object = this.sync;
                synchronized (object) {
                    this.timing = -1L;
                }
                this.engine.flush();
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (NullPointerException ie) {
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception ie) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

