/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.util.Arrays;
import org.maachang.util.ConvertParam;

public class Flag {
    protected static final int ETC_MASK = 63;
    protected static final int FSS_MASK = -64;
    protected static final int RIGHT_SHIFT = 6;
    private int use = 0;
    private int max = 0;
    private int maxPos = 0;
    private long[] flags = null;

    private Flag() {
    }

    public Flag(int size) throws Exception {
        if (size <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.use = 0;
        this.max = ((size & 0xFFFFFFC0) >> 6) + ((size & 0x3F) != 0 ? 1 : 0);
        this.maxPos = this.max * 64;
        this.flags = new long[this.max];
        Arrays.fill(this.flags, 0L);
    }

    public synchronized void clear() {
        this.use = 0;
        this.max = 0;
        this.maxPos = 0;
        this.flags = null;
    }

    public synchronized void expansion(int size) throws Exception {
        if (size <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int mx = ((size & 0xFFFFFFC0) >> 6) + (((size += this.maxPos) & 0x3F) != 0 ? 1 : 0);
        long[] pos = new long[mx];
        Arrays.fill(pos, 0L);
        System.arraycopy(this.flags, 0, pos, 0, this.max);
        this.max = mx;
        this.maxPos = mx * 64;
        this.flags = pos;
    }

    public synchronized void setPos(int pos) throws Exception {
        if (pos < 0 || pos >= this.maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int innerPos = pos & 0x3F;
        int thisPos = (pos & 0xFFFFFFC0) >> 6;
        if ((1L << (int)((long)innerPos) & this.flags[thisPos]) != 0L) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bON\u3067\u3059");
        }
        this.flags[thisPos] = 1L << (int)((long)innerPos) | this.flags[thisPos];
        ++this.use;
    }

    public synchronized void removePos(int pos) throws Exception {
        if (pos < 0 || pos >= this.maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int innerPos = pos & 0x3F;
        int thisPos = (pos & 0xFFFFFFC0) >> 6;
        if ((1L << (int)((long)innerPos) & this.flags[thisPos]) == 0L) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bOFF\u3067\u3059");
        }
        this.flags[thisPos] = (1L << (int)((long)innerPos) ^ 0xFFFFFFFFFFFFFFFFL) & this.flags[thisPos];
        --this.use;
    }

    public synchronized boolean getPos(int pos) throws Exception {
        if (pos < 0 || pos >= this.maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3[" + pos + "]\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.targetPos(pos);
    }

    private boolean targetPos(int pos) {
        int innerPos = pos & 0x3F;
        int thisPos = (pos & 0xFFFFFFC0) >> 6;
        return (1L << (int)((long)innerPos) & this.flags[thisPos]) != 0L;
    }

    public synchronized int useNextPos(int pos) throws Exception {
        if (pos < -1 || pos >= this.maxPos) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ++pos;
        while (pos < this.maxPos) {
            if (this.targetPos(pos)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public synchronized int usePos(int pos) throws Exception {
        if (pos < 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = this.max;
        int i = (pos & 0xFFFFFFC0) >> 6;
        while (i < len) {
            if (this.flags[i] != -1L) {
                long c = this.flags[i];
                long j = 0L;
                while (j < 64L) {
                    if ((c & 1L << (int)j) == 0L) {
                        return i * 64 + (int)j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    public synchronized int usePosBySet(int pos) throws Exception {
        int u = this.usePos(pos);
        if (u == -1) {
            return -1;
        }
        this.setPos(u);
        return u;
    }

    public synchronized int size() {
        return this.use;
    }

    public synchronized int maxSize() {
        return this.maxPos;
    }

    public synchronized byte[] save() throws Exception {
        int flagLen = this.flags.length;
        int len = 16 + 8 * flagLen;
        byte[] ret = new byte[len];
        int pnt = 0;
        ConvertParam.convertInt(ret, pnt, len);
        ConvertParam.convertInt(ret, pnt += 4, this.use);
        ConvertParam.convertInt(ret, pnt += 4, this.max);
        ConvertParam.convertInt(ret, pnt += 4, this.maxPos);
        pnt += 4;
        int i = 0;
        while (i < flagLen) {
            ConvertParam.convertLong(ret, pnt, this.flags[i]);
            pnt += 8;
            ++i;
        }
        return ret;
    }

    public static final Flag load(byte[] binary) throws Exception {
        if (binary == null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u60c5\u5831\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Flag ret = new Flag();
        int pnt = 4;
        ret.use = ConvertParam.convertInt(pnt, binary);
        ret.max = ConvertParam.convertInt(pnt += 4, binary);
        ret.maxPos = ConvertParam.convertInt(pnt += 4, binary);
        pnt += 4;
        int len = ret.max;
        ret.flags = new long[len];
        int i = 0;
        while (i < len) {
            ret.flags[i] = ConvertParam.convertLong(pnt, binary);
            pnt += 8;
            ++i;
        }
        return ret;
    }
}

